/*
 * Decompiled with CFR 0.152.
 */
package org.qsos.utils;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.jdom.JDOMException;
import org.qsos.data.Element;
import org.qsos.data.IElement;
import org.qsos.data.ISheet;
import org.qsos.transformation.DesXMLizer;
import org.qsos.transformation.XMLizer;
import org.qsos.utils.ILibQSOS;
import org.qsos.utils.Search;
import org.qsos.utils.SimpleMenuEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibQSOS
implements ILibQSOS {
    private Search search = new Search();

    private void reInitSearch(String type, String name, int numDesc) {
        this.search.setType(type);
        this.search.setName(name);
        this.search.setNumDesc(numDesc);
    }

    private void reInitSearch(String type, String name, int numDesc, String string2set) {
        this.search.setType(type);
        this.search.setName(name);
        this.search.setNumDesc(numDesc);
        this.search.setString2set(string2set);
    }

    public LibQSOS() {
        this.reInitSearch("", "", -1);
    }

    public LibQSOS(ISheet sheet) {
        this.reInitSearch("", "", -1);
        this.search.setSheet(sheet);
    }

    @Override
    public void load(URL url) {
        DesXMLizer desxml = new DesXMLizer();
        try {
            this.search.setSheet(desxml.transformFromXML(url));
        }
        catch (JDOMException e) {
            System.err.println("Can't load file");
        }
        catch (IOException e) {
            System.err.println("Can't find file");
        }
    }

    @Override
    public ISheet getSheet() {
        return this.search.getSheet();
    }

    @Override
    public void setSheet(ISheet sheet) {
        this.search.setSheet(sheet);
    }

    @Override
    public List<SimpleMenuEntry> getSimpleTree() {
        return this.search.getSimpleTree();
    }

    @Override
    public String Debugaffichage(List<SimpleMenuEntry> list) {
        String res = "";
        for (SimpleMenuEntry menu : list) {
            if (menu.getName() == null) continue;
            for (int i = 0; i <= menu.getDeep(); ++i) {
                res = res + " ";
            }
            res = res + menu.getName() + "\n";
        }
        return res;
    }

    @Override
    public String getDescByName(String name, int numDesc) {
        try {
            this.reInitSearch("name", name, numDesc);
            return this.search.searchString();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    @Override
    public void setCommentByName(String name, String comment) {
        try {
            this.reInitSearch("name", name, -1);
            this.search.searchIElement().setComment(comment);
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
        }
    }

    @Override
    public String getCommentByName(String name) {
        try {
            this.reInitSearch("name", name, -1);
            return this.search.searchIElement().getComment();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    @Override
    public String getScoreByName(String name) {
        try {
            this.reInitSearch("name", name, -1);
            return this.search.searchIElement().getScore();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    @Override
    public void setScoreByName(String name, String score) {
        try {
            this.reInitSearch("name", name, -1);
            this.search.searchIElement().setScore(score);
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
        }
    }

    @Override
    public String getAuthors() {
        try {
            this.reInitSearch("meta", "name", -1);
            return this.search.searchString();
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
            return null;
        }
    }

    @Override
    public void addAuthor(String nameString, String emailString) {
        try {
            this.reInitSearch("meta", "authors", -1);
            IElement temp = this.search.searchIElement();
            Element author = new Element(null, "author", null, null, "", null, temp);
            Element email = emailString != null ? new Element(null, "email", null, null, emailString, null, author) : new Element(null, "email", null, null, null, null, author);
            Element name = nameString != null ? new Element(null, "name", null, null, nameString, null, author) : new Element(null, "name", "", "", "", null, author);
            author.addElement(email);
            author.addElement(name);
            temp.addElement(author);
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
        }
    }

    @Override
    public void delAuthor(String name) {
        try {
            this.reInitSearch("meta", "authors", -1);
            IElement authors = this.search.searchIElement();
            LinkedList<IElement> list = new LinkedList<IElement>();
            for (IElement author : authors.getElements()) {
                for (IElement child : author.getElements()) {
                    if (!child.getMeta().equals("name") || !child.getText().contains(name)) continue;
                    list.add(author);
                }
            }
            for (IElement aut : list) {
                authors.delElement(aut);
            }
        }
        catch (IOException e) {
            System.err.println("Can't find Key");
        }
    }

    @Override
    public String getAppname() {
        this.reInitSearch("meta", "appname", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setAppname(String appname) {
        this.reInitSearch("meta", "appname", -1, appname);
        this.search.searchAndSet();
    }

    @Override
    public String getLanguage() {
        this.reInitSearch("meta", "language", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setLanguage(String language) {
        this.reInitSearch("meta", "language", -1, language);
        this.search.searchAndSet();
    }

    @Override
    public String getRelease() {
        this.reInitSearch("meta", "release", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setRelease(String release) {
        this.reInitSearch("meta", "release", -1, release);
        this.search.searchAndSet();
    }

    @Override
    public String getLicenselist() {
        return null;
    }

    @Override
    public String getLicenseId() {
        this.reInitSearch("meta", "licenseid", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setLicenseId(String licenseId) {
        this.reInitSearch("meta", "licenseid", -1, licenseId);
        this.search.searchAndSet();
    }

    @Override
    public String getLicenseDesc() {
        this.reInitSearch("meta", "licensedesc", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setLicenseDesc(String licensedesc) {
        this.reInitSearch("meta", "licensedesc", -1, licensedesc);
        this.search.searchAndSet();
    }

    @Override
    public String getUrl() {
        this.reInitSearch("meta", "url", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setUrl(String url) {
        this.reInitSearch("meta", "url", -1, url);
        this.search.searchAndSet();
    }

    @Override
    public String getDesc() {
        this.reInitSearch("meta", "header", -1);
        return this.search.searchAndGetIElement().getDesc();
    }

    @Override
    public void setDesc(String desc) {
        this.reInitSearch("meta", "header", -1);
        this.search.searchAndGetIElement().setDesc(desc);
    }

    @Override
    public String getDemoUrl() {
        this.reInitSearch("meta", "demourl", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setDemoUrl(String demourl) {
        this.reInitSearch("meta", "demourl", -1, demourl);
        this.search.searchAndSet();
    }

    @Override
    public String getQsosformat() {
        this.reInitSearch("meta", "qsosformat", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setQsosformat(String qsosformat) {
        this.reInitSearch("meta", "qsosformat", -1, qsosformat);
        this.search.searchAndSet();
    }

    @Override
    public String getQsosspecificformat() {
        this.reInitSearch("meta", "qsosspecificformat", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setQsosspecificformat(String qsosspecificformat) {
        this.reInitSearch("meta", "qsosspecificformat", -1, qsosspecificformat);
        this.search.searchAndSet();
    }

    @Override
    public String getQsosappfamily() {
        this.reInitSearch("meta", "qsosappfamily", -1);
        return this.search.searchAndGetString();
    }

    @Override
    public void setQsosappfamily(String qsosappfamily) {
        this.reInitSearch("meta", "qsosappfamily", -1, qsosappfamily);
        this.search.searchAndSet();
    }

    @Override
    public void write(String path) {
        XMLizer xml = new XMLizer();
        xml.transformToXml(this.search.getSheet(), path);
    }
}

