/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JFireGlassPane
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 8377972503397815117L;
    private JFrame rootFrame = null;

    public JFireGlassPane(JFrame rootFrame) {
        this.rootFrame = rootFrame;
        rootFrame.setGlassPane(this);
        rootFrame.addMouseListener(this);
        this.setOpaque(false);
        this.setVisible(true);
    }

    private void redispatchMouseEvent(MouseEvent e) {
        Component component;
        Point glassPanePoint = e.getPoint();
        Container container = this.rootFrame.getContentPane();
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, container);
        if (e.getY() <= this.getSize().width - 40 || e.getX() < 20) {
            // empty if block
        }
        if (containerPoint.y >= 0 && (component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) != null) {
            Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.red);
        int offset = 20;
        g2.fillOval(this.getSize().width - 160, offset, 20, 20);
        g2.fillOval(this.getSize().width - 120, offset, 20, 20);
        g2.fillOval(this.getSize().width - 80, offset, 20, 20);
        g2.fillOval(this.getSize().width - 40, offset, 20, 20);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.redispatchMouseEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchMouseEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchMouseEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchMouseEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.redispatchMouseEvent(e);
    }
}

