/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device;

import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;

public class DeviceCommandRequest {
    private Command request = null;
    private Command response = null;
    private Exception error = null;
    private long requestTime = 0L;
    private long responseTime = 0L;

    public DeviceCommandRequest(Command request) {
        if (request == null) {
            throw new NullPointerException("request may not be null");
        }
        this.request = request;
        this.requestTime = System.currentTimeMillis();
    }

    public void waitForResponseChecked() {
        this.waitForResponse();
        if (this.response == null) {
            throw new IllegalStateException("Response is null from request " + this.request.getCommandName().name());
        }
        if (this.request == this.response) {
            throw new IllegalStateException("Response is equal to request.");
        }
        if (this.request.getCommandName() == CommandName.help && "done".equals(this.response.getArgu0())) {
            return;
        }
        if (this.request.getCommandName().getType() == CommandVariableType.INFO && "done".equals(this.response.getArgu0())) {
            return;
        }
        if (!this.request.getArgu0().equals(this.response.getArgu0())) {
            throw new IllegalStateException("Response argument is different excepted: '" + this.request.getArgu0() + "' raw: '" + this.request.getLineRaw() + "' got: '" + this.response.getLineRaw() + "'");
        }
    }

    public void waitForResponse() {
        for (int i = 0; i < 150; ++i) {
            if (this.response != null) {
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public Command getRequest() {
        return this.request;
    }

    public void setResponse(Command response) {
        if (response == null) {
            throw new NullPointerException("response may not be null");
        }
        this.response = response;
        this.responseTime = System.currentTimeMillis();
    }

    public Command getResponse() {
        return this.response;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public Exception getError() {
        return this.error;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }
}

