/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JFireBorder
implements Border,
MouseListener {
    private int radius = 10;
    boolean entered = false;
    private JComponent comp = null;
    private String title;
    private static JFireBorder lastFireBorder = null;
    private GradientPaint gradientNormal = null;
    private GradientPaint gradientEntered = null;
    private int gradientWidth = 0;

    public JFireBorder(String title, JComponent comp) {
        this.comp = comp;
        this.title = title;
        comp.addMouseListener(this);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.getTitleHeight(c) + 1, 1, this.radius - 2, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color startColor;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int titleHeight = this.getTitleHeight(c);
        if (this.gradientWidth != width) {
            this.gradientNormal = null;
            this.gradientEntered = null;
        }
        this.gradientWidth = width;
        Color endColor = UIManager.getColor("control");
        if (endColor == null) {
            endColor = c.getBackground();
        }
        if ((startColor = UIManager.getColor("nimbusBorder")) == null) {
            startColor = c.getForeground();
        }
        if (this.gradientNormal == null) {
            this.gradientNormal = new GradientPaint(0.0f, 0.0f, startColor, titleHeight * 5, width / 3, endColor, false);
        }
        if (this.gradientEntered == null) {
            startColor = UIManager.getColor("nimbusFocus");
            if (startColor == null) {
                startColor = c.getForeground();
            }
            this.gradientEntered = new GradientPaint(0.0f, 0.0f, startColor, titleHeight * 5, width / 3, endColor, false);
        }
        if (this.entered) {
            g2.setPaint(this.gradientEntered);
        } else {
            g2.setPaint(this.gradientNormal);
        }
        g2.fillRoundRect(x, y, width, titleHeight, this.radius, this.radius);
        g2.fillRect(x, titleHeight / 2, this.radius + 1, titleHeight / 2);
        g2.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        if (this.title == null) {
            return;
        }
        Font font = UIManager.getFont("TitledBorder.font");
        g2.setColor(c.getForeground());
        FontMetrics metrics = c.getFontMetrics(font);
        g2.setFont(font);
        g2.drawString(this.title, x + 8, y + (titleHeight - metrics.getHeight()) / 2 + metrics.getAscent());
    }

    protected int getTitleHeight(Component c) {
        Font font = UIManager.getFont("TitledBorder.font");
        FontMetrics metrics = c.getFontMetrics(font);
        return (int)((double)metrics.getHeight() * 1.4);
    }

    public GradientPaint getGradient() {
        if (this.entered) {
            return this.gradientEntered;
        }
        return this.gradientNormal;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.entered && lastFireBorder == this) {
            return;
        }
        this.entered = true;
        if (this.comp != null) {
            this.comp.repaint();
            if (lastFireBorder != null) {
                JFireBorder.lastFireBorder.entered = false;
                JFireBorder.lastFireBorder.comp.repaint();
            }
            lastFireBorder = this;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

