/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.ui.PulseFireTimeData;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JFireGraph
extends JPanel
implements PulseFireTimeData.TimeDataListener {
    private static final long serialVersionUID = -2926409292528475132L;
    final int PAD = 0;
    private CommandName commandName = null;
    private PulseFireTimeData timeDataStore = null;
    private Color gridColor = null;

    public JFireGraph(CommandName commandName) {
        this.commandName = commandName;
        this.timeDataStore = PulseFireUI.getInstance().getTimeData();
        this.gridColor = UIManager.getColor("nimbusGreen").darker();
        this.setPreferredSize(new Dimension(440, 220));
        this.setMinimumSize(new Dimension(80, 40));
        this.setBorder(BorderFactory.createEmptyBorder());
        PulseFireUI.getInstance().getTimeData().addTimeDataListener(commandName, this);
    }

    public CommandName getCommandName() {
        return this.commandName;
    }

    public Color randomColor(int idx) {
        int blue;
        int green;
        int red;
        Random random = new Random();
        if (idx > 16) {
            idx /= 2;
        }
        if ((red = (random = new Random()).nextInt(++idx * 16)) < 33) {
            red += random.nextInt(133);
        }
        if ((green = (random = new Random()).nextInt(idx * 16)) < 33) {
            green += random.nextInt(166);
        }
        if ((blue = (random = new Random()).nextInt(idx * 16)) < 33) {
            blue += random.nextInt(199);
        }
        return new Color(red, green, blue);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(this.gridColor);
        double maxValue = this.getSize().height;
        double maxRValue = 0.0;
        double minRValue = 100000.0;
        List<PulseFireTimeData.TimeData> timeData = this.timeDataStore.getTimeData(this.commandName);
        for (int ii = 0; ii < timeData.size(); ++ii) {
            PulseFireTimeData.TimeData t = timeData.get(ii);
            if (!this.commandName.isIndexedA()) {
                if ((double)t.dataPoint > maxValue) {
                    maxValue = t.dataPoint;
                }
                if ((double)t.dataPoint > maxRValue) {
                    maxRValue = t.dataPoint;
                }
                if (!((double)t.dataPoint < minRValue)) continue;
                minRValue = t.dataPoint;
                continue;
            }
            for (int i = 0; i < this.commandName.getMaxIndexA(); ++i) {
                if ((double)t.dataPointIdx[i] > maxValue) {
                    maxValue = t.dataPointIdx[i];
                }
                if ((double)t.dataPointIdx[i] > maxRValue) {
                    maxRValue = t.dataPointIdx[i];
                }
                if (!((double)t.dataPointIdx[i] < minRValue)) continue;
                minRValue = t.dataPointIdx[i];
            }
        }
        if (minRValue == 100000.0) {
            minRValue = 0.0;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        double xScale = 1.0;
        if (!timeData.isEmpty()) {
            xScale = (w - 0) / timeData.size();
        }
        double yScale = (double)(h - 0) / (maxValue + 10.0);
        int yLines = 10;
        int xLines = 20;
        for (int y = 0; y <= yLines; ++y) {
            g2.drawLine(0, h / yLines * y, w, h / yLines * y);
        }
        for (int x = 0; x <= xLines; ++x) {
            g2.drawLine(w / xLines * x, 0, w / xLines * x, h);
        }
        int x0 = 0;
        int y0 = h - 0;
        int x1 = -1;
        int y1 = -1;
        int dataPoint = 0;
        int j = 1;
        if (!this.commandName.isIndexedA()) {
            for (int tt = 0; tt < timeData.size(); ++tt) {
                PulseFireTimeData.TimeData t = timeData.get(tt);
                g2.setPaint(Color.GREEN);
                dataPoint = t.dataPoint;
                int x = x0 + (int)(xScale * (double)(j + 1));
                int y = y0 - (int)(yScale * (double)dataPoint);
                if (x1 != -1) {
                    g2.drawLine(x1, y1, x, y);
                }
                x1 = x;
                y1 = y;
                ++j;
            }
        } else {
            for (int i = 0; i < this.commandName.getMaxIndexA(); ++i) {
                PulseFireTimeData.TimeDataKey key = PulseFireUI.getInstance().getTimeData().getKeyFromName(this.commandName);
                if (key.dataColorIdx[i] == null) {
                    key.dataColorIdx[i] = this.randomColor(i);
                }
                g2.setColor(key.dataColorIdx[i]);
                x1 = -1;
                y1 = -1;
                dataPoint = 0;
                j = 0;
                for (int ii = 0; ii < timeData.size(); ++ii) {
                    PulseFireTimeData.TimeData t = timeData.get(ii);
                    dataPoint = t.dataPointIdx[i];
                    int x = x0 + (int)(xScale * (double)(j + 1));
                    int y = y0 - (int)(yScale * (double)dataPoint);
                    if (x1 != -1) {
                        g2.drawLine(x1, y1, x, y);
                    }
                    x1 = x;
                    y1 = y;
                    ++j;
                }
            }
        }
        Color back = this.getBackground();
        Color trans = new Color(back.getRed(), back.getGreen(), back.getBlue(), 150);
        g2.setPaint(trans);
        g2.fillRect(0, 0, 150, 70);
        g2.setPaint(this.gridColor);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setPaint(UIManager.getColor("text"));
        g2.drawString("Name:", 7, 20);
        g2.drawString(this.commandName.name(), 50, 20);
        if (!this.commandName.isIndexedA()) {
            Command cmd;
            g2.drawString("Value:", 7, 35);
            String valueStr = "" + dataPoint;
            int dotIndex = 0;
            if (CommandName.dev_amp == this.commandName && (cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.dev_amp_dot)) != null && cmd.getArgu0() != null && !cmd.getArgu0().isEmpty()) {
                dotIndex = new Integer(cmd.getArgu0());
            }
            if (CommandName.dev_volt == this.commandName && (cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.dev_volt_dot)) != null && cmd.getArgu0() != null && !cmd.getArgu0().isEmpty()) {
                dotIndex = new Integer(cmd.getArgu0());
            }
            if (CommandName.dev_temp == this.commandName && (cmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.dev_temp_dot)) != null && cmd.getArgu0() != null && !cmd.getArgu0().isEmpty()) {
                dotIndex = new Integer(cmd.getArgu0());
            }
            if (dotIndex > 0) {
                String numberValue;
                String dotValue;
                int idx = valueStr.length() - dotIndex;
                if (idx < 0) {
                    idx = 0;
                }
                if ((dotValue = valueStr.substring(idx, valueStr.length())).length() < dotIndex) {
                    int zeros = dotIndex - dotValue.length();
                    for (int i = 0; i < zeros; ++i) {
                        dotValue = "0" + dotValue;
                    }
                }
                if ((numberValue = valueStr.substring(0, idx)).isEmpty()) {
                    numberValue = "0";
                }
                valueStr = numberValue + "." + dotValue;
            }
            g2.drawString(valueStr, 50, 35);
        }
        g2.drawString("Min:", 7, 50);
        g2.drawString("" + minRValue, 50, 50);
        g2.drawString("Max:", 7, 65);
        g2.drawString("" + maxRValue, 50, 65);
    }

    @Override
    public void updateTimeData() {
        this.repaint();
    }
}

