/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceDataListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandWire;

public class JPanelConsole
extends JPanel
implements DeviceDataListener,
DeviceConnectListener,
ActionListener,
PulseFireUISettingListener {
    private static final long serialVersionUID = -8155913876470234844L;
    private JTextArea consoleLog = null;
    private JTextField consoleInput = null;
    private int consoleLogLines = 0;
    private volatile int consoleLogLinesMax = 255;
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    public JPanelConsole() {
        this.consoleLogLinesMax = new Integer(PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.CONSOLE_LINES));
        this.setLayout(new GridLayout(1, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel innerPanel = JComponentFactory.createJFirePanel("Console");
        innerPanel.setLayout(new BorderLayout());
        this.add(innerPanel);
        this.consoleLog = new JTextArea(10, 50);
        this.consoleLog.setMargin(new Insets(2, 2, 2, 2));
        this.consoleLog.setAutoscrolls(true);
        this.consoleLog.setEditable(false);
        JScrollPane consoleScrollPane = new JScrollPane(this.consoleLog);
        consoleScrollPane.setHorizontalScrollBarPolicy(31);
        consoleScrollPane.setVerticalScrollBarPolicy(22);
        consoleScrollPane.getViewport().setOpaque(false);
        innerPanel.add((Component)consoleScrollPane, "Center");
        this.consoleInput = new JTextField(30);
        this.consoleInput.setMargin(new Insets(5, 5, 5, 5));
        this.consoleInput.addActionListener(this);
        this.consoleInput.setEnabled(false);
        JPanel consoleActionPanel = new JPanel();
        consoleActionPanel.setLayout(new BorderLayout());
        consoleActionPanel.add((Component)this.consoleInput, "Before");
        JButton consoleClear = new JButton("Clear");
        consoleClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanelConsole.this.consoleLogLines = 0;
                JPanelConsole.this.consoleLog.setText("");
            }
        });
        consoleActionPanel.add((Component)consoleClear, "After");
        innerPanel.add((Component)consoleActionPanel, "South");
        PulseFireUI.getInstance().getDeviceManager().addDeviceDataListener((DeviceDataListener)this);
        PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.CONSOLE_LINES, this);
        this.updateText("Ready to connect.", "##");
    }

    public void deviceDataReceived(String data) {
        this.updateText(data, "");
    }

    public void deviceDataSend(String data) {
        this.updateText(data, ">>");
    }

    private void updateText(String data, String prefix) {
        this.consoleLog.append(this.timeFormat.format(new Date()));
        this.consoleLog.append(" ");
        this.consoleLog.append(prefix);
        this.consoleLog.append(" ");
        this.consoleLog.append(data);
        this.consoleLog.append("\n");
        ++this.consoleLogLines;
        if (this.consoleLogLines > this.consoleLogLinesMax) {
            int ll;
            String t = this.consoleLog.getText();
            int l = 0;
            int rm = this.consoleLogLinesMax / 2;
            for (int i = 0; i < rm && (ll = t.indexOf(10, l + 1)) != -1; ++i) {
                l = ll;
            }
            String tt = t.substring(l, t.length());
            this.consoleLog.setText(tt);
            this.consoleLogLines = rm;
        }
        this.consoleLog.repaint();
        this.consoleLog.setCaretPosition(this.consoleLog.getText().length());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.consoleInput.getText().isEmpty()) {
            return;
        }
        try {
            Command cmd = CommandWire.decodeCommand((String)this.consoleInput.getText());
            PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd);
        }
        catch (Exception e) {
            this.updateText(e.getMessage(), "## Err:");
        }
        this.consoleInput.setText("");
    }

    public void deviceConnect() {
        this.consoleInput.setEnabled(true);
        this.updateText("Connected succesfully.", "##");
    }

    public void deviceDisconnect() {
        this.consoleInput.setEnabled(false);
        this.updateText("Closed connection succesfully.", "##");
        this.updateText("Ready to connect.", "##");
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        this.consoleLogLinesMax = new Integer(value);
        this.consoleLogLines = 0;
        this.consoleLog.setText("");
    }
}

