/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/


#include <curses.h>
#include "fildir.h"

/* variables & definitions */

#define B_OK		0x0001
#define B_YES 		0x0002
#define B_NO 		0x0004
#define B_CANCEL	0x0008

#define KEY_ESC		27
#define CTRL(x)		((x)&0x1f)
//#define ALT(x)		(0x200 | (unsigned int)(x))


/* the maximal buffer size for copying (standard: 5MB) */

#define MAX_CBUF_SIZE 	5000000


extern const char *xb[];//={"","kB","MB","GB","TB"};
extern const char *button[];//={"CANCEL","NO","YES","OK"};

/* we could read the strings from an external file */

extern const char *strings[]; /*={
"Error while reading dir.",\
"Not enough memory.",\
"Unable to delete",\
"Delete"};*/


typedef struct opanel
{

	/* position of the left, upper corner */

    int posx,posy;

	/* width and height of the panel */
	
    int width,height;

	/* the number of columns in which the names of the inodes are written - we
	   need to change the name */
	
    int columns;

	/* active panel? */
	
    int active;
    int reread;
    int sort_mode;
    unsigned long sel_count;
    unsigned long sel_size;

    int virtual_dir;		// boolean

	/* directory */
	
    DirStruct *dir;

	/* first visible inode */
	
    DirStruct *first;

	/* selected inode */
	
    DirStruct *sel_ds;

	/* name of the selected inode or of the inode which needs to be selected */
	
    char *sel_name;

	/* current path */
	
    char *path;
    WINDOW *win;       
} OPANEL;

/* function prototypes */


/* viewport */

/* creates two panels */

int	viewportCreate();

/* refreshes two panels */

void 	viewportRefresh();
void	viewportDelete();

/* writes some info about files */
int writeinfo(int mode);

/* panels */

/* creates panel */

OPANEL 	*opanelCreate(int x,int y,int width,int height);

/* removes panel */

void 	opanelDelete(OPANEL *p);

/* refreshes panel */

int 	opanelRefresh(OPANEL *p);

/* curses (de)initialization */

int 	cursesInit();	
void 	cursesDestroy();	

/* keys */

/* reacts if key is pressed */

int 	keyReact(int i);

/* dialogs & widgets */

int 	dlgMessageBox(int but,char* buf,char *name,char *message);
int 	dlgDelete(OPANEL *p);
int 	dlgCopy(OPANEL *p, char *dest);
