#!/usr/bin/python

#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import unittest
from testsPath import *
from qt import *
from OBBFuncts import kickApp
import sys

TEST_MODULES = [ "startUpTest",
                 "OBBAppTest",
                 "soundTest",
                 "FloaterTest",
                 "PixmapSetTest",
                 "ImageLoaderTest",
                 "OBBWidgetTest",
                 ]

def generateSuite():
    testSuite = unittest.TestSuite()
    for module in TEST_MODULES:
        exec "import %s" % module
        exec "testSuite.addTest(%s.suite())" % module
    return testSuite

def main():
    # most tests need a QApplication to be instanciated
    app = QApplication(sys.argv)

    suite = generateSuite()
    if "-g" in sys.argv:
        # import here so it won't fail on systems without gui
        import Tkinter as tk
        from unittestgui import TkTestRunner
        root = tk.Tk()
        root.title("PyUnit")
        runner = TkTestRunner(root, "testAll.generateSuite")
        root.protocol('WM_DELETE_WINDOW', root.quit)
        root.mainloop()

        runner = TkTestRunner
    else:
        runner = unittest.TextTestRunner()
        runner.run( suite )

    kickApp(app)
    
if __name__=="__main__":
    main()
