/* This file is part of the MPFRCPP Library.

   Copyright (c) 2006-2007 Alexey V. Beshenov <bav.272304@gmail.com>.

   The MPFRCPP Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   The MPFRCPP Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the MPFRCPP Library; see the file COPYING.LIB. If
   not, write to the Free Software Foundation, Inc., 51 Franklin Street,
   Fifth Floor, Boston, MA 02110-1301, USA. */

/**
 * @file nacre_polynomial_roots.cpp
 * @date 2007-04-xx
 */

#include <iostream>
#include <vector>
#include <mpfrcpp/mpfrcpp.hpp>
#include <mpfrcpp/extra/complex.hpp>
#include <mpfrcpp/extra/polynomial.hpp>

int main () {

    size_t n = /*10, 21, 43, 87, ...*/ 43;

    mpfr::Library.setPrecision(mpfr::Precision(100));

    mpfr::Polynomial<mpfr::Real> P =
         mpfr::LegendrePolynomial<mpfr::Real> (n);
    std::cout << "P_" << n << " = " << P << std::endl << std::endl;

    std::vector<mpfr::Complex> roots =
         PolynomialRoots(mpfr::Polynomial<mpfr::Complex>(P),
                         mpfr::Real::epsilon(), 10000);

    for (size_t i = 0; i < roots.size(); i++)
        std::cout << "x_" << i << " = " << roots.at(i).real() << std::endl;

    return 0;
}
