// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief  C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <Python.h>
#include "file.h"
#include "folder.h"
#include "reader.h"
#include "writer.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief module methods
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyMethodDef module_methods[] =
{
  {
    NULL,
    NULL,
    0,
    NULL
  } // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief create module
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
new_io_module ()
{
  // initialize module
  PyObject* module = Py_InitModule3 (
    "io",
    module_methods,
    "Mobius Forensic Toolkit mobius.io module"
  );

  // build types
  if (PyType_Ready (&io_file_t) < 0)
    return nullptr;

  if (PyType_Ready (&io_folder_t) < 0)
    return nullptr;

  if (PyType_Ready (&io_reader_t) < 0)
    return nullptr;

  if (PyType_Ready (&io_writer_t) < 0)
    return nullptr;

  // add types
  Py_INCREF (&io_file_t);
  PyModule_AddObject (module, "file", (PyObject *) &io_file_t);

  Py_INCREF (&io_folder_t);
  PyModule_AddObject (module, "folder", (PyObject *) &io_folder_t);

  Py_INCREF (&io_reader_t);
  PyModule_AddObject (module, "reader", (PyObject *) &io_reader_t);

  Py_INCREF (&io_writer_t);
  PyModule_AddObject (module, "writer", (PyObject *) &io_writer_t);

  // return module
  return module;
}
