#ifndef __MOBIUS_DECODER_DATA_DECODER_H__
#define __MOBIUS_DECODER_DATA_DECODER_H__

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/io/reader.h>
#include <mobius/datetime/datetime.h>
#include <string>

namespace mobius
{
namespace decoder
{        
class data_decoder
{
public:
  using size_type = mobius::io::reader::size_type;
  using offset_type = mobius::io::reader::offset_type;

  explicit data_decoder (mobius::io::reader);
  explicit data_decoder (const mobius::bytearray&);
  void skip (size_type);
  void seek (size_type);
  size_type tell () const;

  // integers
  std::int8_t get_int8 ();
  std::int16_t get_int16_le ();
  std::int32_t get_int32_le ();
  std::uint8_t get_uint8 ();
  std::uint16_t get_uint16_le ();
  std::uint16_t get_uint16_be ();
  std::uint32_t get_uint32_le ();
  std::uint32_t get_uint32_be ();
  std::uint64_t get_uint64_le ();
  std::uint64_t get_uint64_be ();

  // date/time
  const mobius::datetime::datetime get_hfs_datetime ();
  const mobius::datetime::datetime get_iso9660_datetime ();
  const mobius::datetime::datetime get_nt_datetime ();
  const mobius::datetime::datetime get_unix_datetime ();

  // other types
  const mobius::bytearray get_bytearray_by_size (std::size_t);
  const std::string get_string_by_size (std::size_t, const std::string& = "ASCII");
  const std::string get_guid ();
  const std::string get_uuid ();
  const std::string get_ipv4 ();

private:
  mobius::io::reader in_;
};

} // namespace decoder
} // namespace mobius

#endif
