// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include "filesystem_iso.h"
#include "filesystem.h"
#include "api_metadata.h"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (filesystem_filesystem_iso_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_descr_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_descr_version (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_descr_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: system_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_system_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_system_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_volume_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_space_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_space_size (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_space_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_set_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_set_size (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_set_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_sequence_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_sequence_number (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_sequence_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: logical_block_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_logical_block_size (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_logical_block_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: path_table_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_path_table_size (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_path_table_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: type_l_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_type_l_path_table (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_l_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: type_l_optional_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_type_l_optional_path_table (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_l_optional_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: type_m_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_type_m_path_table (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_m_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: type_m_optional_path_table getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_type_m_optional_path_table (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_type_m_optional_path_table ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: volume_set_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_volume_set_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_volume_set_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: publisher_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_publisher_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_publisher_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: data_preparer_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_data_preparer_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_data_preparer_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: application_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_application_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_application_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: copyright_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_copyright_file_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_copyright_file_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: abstract_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_abstract_file_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_abstract_file_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: bibliographic_file_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_bibliographic_file_id (filesystem_filesystem_iso_o *self)
{
  return PyString_from_std_string (self->obj->get_bibliographic_file_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: creation_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_creation_time (filesystem_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_creation_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: last_modification_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_last_modification_time (filesystem_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_last_modification_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: expiration_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_expiration_time (filesystem_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_expiration_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: effective_time getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_effective_time (filesystem_filesystem_iso_o *self)
{
  return PyDateTime_from_datetime (self->obj->get_effective_time ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: file_structure_version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_getter_file_structure_version (filesystem_filesystem_iso_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_file_structure_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef tp_getset[] =
{
  {
    (char *) "volume_descr_version",
    (getter) tp_getter_volume_descr_version,
    (setter) 0,
    (char *) "volume description version", NULL
  },
  {
    (char *) "system_id",
    (getter) tp_getter_system_id,
    (setter) 0,
    (char *) "system identifier", NULL
  },
  {
    (char *) "volume_id",
    (getter) tp_getter_volume_id,
    (setter) 0,
    (char *) "volume identifier", NULL
  },
  {
    (char *) "volume_space_size",
    (getter) tp_getter_volume_space_size,
    (setter) 0,
    (char *) "volume space size", NULL
  },
  {
    (char *) "volume_set_size",
    (getter) tp_getter_volume_set_size,
    (setter) 0,
    (char *) "volume set size", NULL
  },
  {
    (char *) "volume_sequence_number",
    (getter) tp_getter_volume_sequence_number,
    (setter) 0,
    (char *) "volume sequence number", NULL
  },
  {
    (char *) "logical_block_size",
    (getter) tp_getter_logical_block_size,
    (setter) 0,
    (char *) "logical block size in bytes", NULL
  },
  {
    (char *) "path_table_size",
    (getter) tp_getter_path_table_size,
    (setter) 0,
    (char *) "path table size in bytes", NULL
  },
  {
    (char *) "type_l_path_table",
    (getter) tp_getter_type_l_path_table,
    (setter) 0,
    (char *) "location of type L path table", NULL
  },
  {
    (char *) "type_l_optional_path_table",
    (getter) tp_getter_type_l_optional_path_table,
    (setter) 0,
    (char *) "location of optional type L path table", NULL
  },
  {
    (char *) "type_m_path_table",
    (getter) tp_getter_type_m_path_table,
    (setter) 0,
    (char *) "location of type M path table", NULL
  },
  {
    (char *) "type_m_optional_path_table",
    (getter) tp_getter_type_m_optional_path_table,
    (setter) 0,
    (char *) "location of optional type M path table", NULL
  },
  {
    (char *) "volume_set_id",
    (getter) tp_getter_volume_set_id,
    (setter) 0,
    (char *) "volume set identifier", NULL
  },
  {
    (char *) "publisher_id",
    (getter) tp_getter_publisher_id,
    (setter) 0,
    (char *) "publisher identifier", NULL
  },
  {
    (char *) "data_preparer_id",
    (getter) tp_getter_data_preparer_id,
    (setter) 0,
    (char *) "data preparer identifier", NULL
  },
  {
    (char *) "application_id",
    (getter) tp_getter_application_id,
    (setter) 0,
    (char *) "application identifier", NULL
  },
  {
    (char *) "copyright_file_id",
    (getter) tp_getter_copyright_file_id,
    (setter) 0,
    (char *) "copyright file identifier", NULL
  },
  {
    (char *) "abstract_file_id",
    (getter) tp_getter_abstract_file_id,
    (setter) 0,
    (char *) "abstract file identifier", NULL
  },
  {
    (char *) "bibliographic_file_id",
    (getter) tp_getter_bibliographic_file_id,
    (setter) 0,
    (char *) "bibliographic file identifier", NULL
  },
  {
    (char *) "creation_time",
    (getter) tp_getter_creation_time,
    (setter) 0,
    (char *) "volume creation date/time", NULL
  },
  {
    (char *) "last_modification_time",
    (getter) tp_getter_last_modification_time,
    (setter) 0,
    (char *) "volume last modification date/time", NULL
  },
  {
    (char *) "expiration_time",
    (getter) tp_getter_expiration_time,
    (setter) 0,
    (char *) "volume expiration date/time", NULL
  },
  {
    (char *) "effective_time",
    (getter) tp_getter_effective_time,
    (setter) 0,
    (char *) "volume effective date/time", NULL
  },
  {
    (char *) "file_structure_version",
    (getter) tp_getter_file_structure_version,
    (setter) 0,
    (char *) "file structure version", NULL
  },
  {NULL, NULL, 0, NULL, NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief filesystem_iso: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject filesystem_filesystem_iso_t =
{
  PyVarObject_HEAD_INIT (NULL, 0)
  "mobius.filesystem.filesystem_iso",          		// tp_name
  sizeof (filesystem_filesystem_iso_o),       		// tp_basicsize
  0,                                         		// tp_itemsize
  (destructor) tp_dealloc,	                     	// tp_dealloc
  0,                                         		// tp_print
  0,                                         		// tp_getattr
  0,                                         		// tp_setattr
  0,                                         		// tp_compare
  0,                                         		// tp_repr
  0,                                         		// tp_as_number
  0,                                         		// tp_as_sequence
  0,                                         		// tp_as_mapping
  0,                                         		// tp_hash
  0,                                         		// tp_call
  0,                                         		// tp_str
  0,                                         		// tp_getattro
  0,                                         		// tp_setattro
  0,                                         		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,  		// tp_flags
  "filesystem_iso class",                    		// tp_doc
  0,                                         		// tp_traverse
  0,                                         		// tp_clear
  0,                                         		// tp_richcompare
  0,                                         		// tp_weaklistoffset
  0,                                         		// tp_iter
  0,                                         		// tp_iternext
  0,                                  	         	// tp_methods
  0,                                         		// tp_members
  tp_getset,             	                      	// tp_getset
  &filesystem_filesystem_t,                   		// tp_base
  0,                                         		// tp_dict
  0,                                         		// tp_descr_get
  0,                                         		// tp_descr_set
  0,                                         		// tp_dictoffset
  0,                                         		// tp_init
  0,                                         		// tp_alloc
  0,                                          		// tp_new
  0,                                       		// tp_free
  0,                                       		// tp_is_gc
  0,                                       		// tp_bases
  0,                                       		// tp_mro
  0,                                       		// tp_cache
  0,                                       		// tp_subclasses
  0,                                       		// tp_weaklist
  0,                                       		// tp_del
  0,                                       		// tp_version_tag
};
