#!/usr/bin/env python

import mobius
import sys

def get_hash (reader):
  h = mobius.crypt.hash ('sha2_512')
  data = reader.read (65536)
  while data:
    h.update (data)
    data = reader.read (65536)
    
  return h.get_hex_digest ()

def print_kff_entry (entry, drive):
  if entry.is_reallocated:
    pass

  elif entry.is_folder ():
    for child in entry.get_children ():
      print_kff_entry (child, drive)

  elif not entry.is_deleted:
    reader = entry.new_reader ()
    if reader:
      h = get_hash (reader)
      print '%s\t%s:%s' % (h, drive, entry.path)

def print_kff (disk):
  for idx, fs in enumerate (mobius.filesystem.get_filesystems (disk)):
    root = fs.get_root_entry ()
    print_kff_entry (root, chr (ord ('C') + idx))

for url in sys.argv[1:]:
   disk = mobius.disk.new_disk_from_url (url)

   if disk.is_available ():
     print_kff (disk)
