// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/unittest.h>
#include <mobius/core/application.h>

void
testcase_application ()
{
  mobius::unittest test ("mobius::core::application");
  mobius::core::application app;
  mobius::core::application app2;

  // constants
  test.ASSERT_EQUAL (app.get_name (), "Mobius Forensic Toolkit");
  test.ASSERT_NOT_EQUAL (app.get_version (), "");
  test.ASSERT_NOT_EQUAL (app.get_title (), "");
  test.ASSERT_NOT_EQUAL (app.get_copyright (), "");

  // unique reference
  test.ASSERT_EQUAL (app.get_name (), app2.get_name ());
  test.ASSERT_EQUAL (app.get_version (), app2.get_version ());
  test.ASSERT_EQUAL (app.get_title (), app2.get_title ());
  test.ASSERT_EQUAL (app.get_copyright (), app2.get_copyright ());
  
  // paths
  test.ASSERT_TRUE (app.get_config_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_config_path ("./"), app.get_config_path (""));

  test.ASSERT_TRUE (app.get_cache_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_cache_path ("./"), app.get_cache_path (""));

  test.ASSERT_TRUE (app.get_data_path ("").length () > 0);
  test.ASSERT_EQUAL (app.get_data_path ("./"), app.get_data_path (""));

  ASSERT_EXCEPTION (test, app.get_config_path ("../x"), std::runtime_error);
  ASSERT_EXCEPTION (test, app.get_cache_path ("../x"), std::runtime_error);

  // config
  app.set_config ("unittest", 1);
  test.ASSERT_TRUE (app.has_config ("unittest"));
  test.ASSERT_EQUAL (app.get_config_int ("unittest"), 1);
  test.ASSERT_EQUAL (app.get_config_string ("unittest"), "1");

  app.set_config ("unittest", 2);
  test.ASSERT_TRUE (app.has_config ("unittest"));
  test.ASSERT_EQUAL (app.get_config_int ("unittest"), 2);
  test.ASSERT_EQUAL (app.get_config_string ("unittest"), "2");

  test.end ();
}

void
unittest_core ()
{
  testcase_application ();
}
