// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/partition/partition_system.h>
#include <mobius/partition/partition_system_impl_apm.h>
#include <mobius/partition/partition_system_impl_dos.h>
#include <mobius/partition/partition_system_impl_gpt.h>
#include <mobius/partition/partition_system_impl_null.h>

namespace mobius
{
namespace partition
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief constructor
//! \param reader stream reader
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
partition_system::partition_system (mobius::io::sector_reader_adaptor reader)
{
  // check partition system
  if (partition_system_impl_gpt::is_instance (reader))
    impl_ = std::make_shared <partition_system_impl_gpt> (reader);

  else if (partition_system_impl_dos::is_instance (reader))
    impl_ = std::make_shared <partition_system_impl_dos> (reader);

  else if (partition_system_impl_apm::is_instance (reader))
    impl_ = std::make_shared <partition_system_impl_apm> (reader);

  else
    impl_ = std::make_shared <partition_system_impl_null> (reader);
}

} // namespace partition
} // namespace mobius
