import mobius.file
import zipfile

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Check zip signature
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def match (path):
  return zipfile.is_zipfile (path)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Handle .zip (.zip)
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class ZipFile (mobius.file.File):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief ZipFile stream
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  class Stream (object):
    def __init__ (self, member, parent):
      self.parent = parent
      self.member = member

    def export (self, path):
      fp = open (path, 'w')
      fp.write (self.parent.read (self.member.filename))
      fp.close ()

    def read (self):
      return self.parent.read (self.member.filename)

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Initialize zipfile
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, path=None):
    mobius.file.File.__init__ (self, path)

    try:
      self.fp = zipfile.ZipFile (path)

    except zipfile.BadZipfile:
      raise Exception, 'invalid .zip file [%s]' % path

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # @brief Get members of zipfile
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __iter__ (self):

    for i in self.fp.infolist ():
      f = mobius.file.File ('%s/%s' % (self.path, i.filename))
      f.parent = self
      f.stream = ZipFile.Stream (i, self.fp)
      f.size = i.file_size
      f.mtime = -1  # @todo usar date_time
      f.mode = -1 # @todo usar internal_attr e external_attr
      f.origin = 'archive/zip'

      yield f
