/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.stack;

import java.io.IOException;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.header.ViaList;
import sip4me.gov.nist.siplite.message.Message;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPServerException;
import sip4me.gov.nist.siplite.stack.SIPServerRequestInterface;
import sip4me.gov.nist.siplite.stack.SIPTransactionStack;
import sip4me.gov.nist.siplite.stack.Transaction;

public class ServerTransaction
extends Transaction
implements SIPServerRequestInterface {
    protected int collectionTime;
    private SIPServerRequestInterface requestOf;
    protected boolean isMapped;

    private void sendSIPResponse(Response transactionResponse) throws IOException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Sending response on ServerTransaction: " + transactionResponse.getTransactionId() + " with first line: " + transactionResponse.getFirstLine());
        }
        if (transactionResponse.getTopmostVia().getParameter("received") == null) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "\"Received\" parameter is null, sending through existing channel");
            }
            this.getMessageChannel().sendMessage(transactionResponse);
        } else {
            ViaHeader via = transactionResponse.getTopmostVia();
            String host = via.getParameter("received");
            int port = via.getPort();
            if (port == -1) {
                port = 5060;
            }
            String transport = via.getTransport();
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "\"Received\" parameter is NOT null; sending through hop " + host + ":" + port + "/" + transport);
            }
            Hop hop = new Hop(String.valueOf(host) + ":" + port + "/" + transport);
            MessageChannel messageChannel = ((SIPTransactionStack)this.getSIPStack()).createRawMessageChannel(hop);
            messageChannel.sendMessage(transactionResponse);
        }
        this.lastResponse = transactionResponse;
    }

    protected ServerTransaction(SIPTransactionStack newSIPMessageStack, MessageChannel newChannelToHeaderUse) {
        super(newSIPMessageStack, newChannelToHeaderUse);
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Creating Server Transaction: " + this);
        }
    }

    public void setRequestInterface(SIPServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public String getProcessingInfo() {
        return this.requestOf.getProcessingInfo();
    }

    public boolean isMessagePartOfTransaction(Message messageToTest) {
        ViaList viaHeaders;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeqHeader().getMethod();
        if ((method.equals("INVITE") || !this.isTerminated()) && (viaHeaders = messageToTest.getViaHeaders()) != null) {
            ViaHeader topViaHeader = (ViaHeader)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toUpperCase().startsWith("z9hG4bK".toUpperCase())) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getOriginalRequest().getCSeqHeader().getMethod().equals("CANCEL") && this.getBranch().equals(messageBranch) && topViaHeader.getSentBy().equals(((ViaHeader)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy()) : this.getBranch().equals(messageBranch) && topViaHeader.getSentBy().equals(((ViaHeader)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy());
            } else {
                boolean skipToHeader;
                String originalFromHeaderTag = this.getOriginalRequest().getFromHeader().getTag();
                String thisFromHeaderTag = messageToTest.getFromHeader().getTag();
                boolean skipFromHeader = originalFromHeaderTag == null || thisFromHeaderTag == null;
                String originalToHeaderTag = this.getOriginalRequest().getTo().getTag();
                String thisToHeaderTag = messageToTest.getTo().getTag();
                boolean bl = skipToHeader = originalToHeaderTag == null || thisToHeaderTag == null;
                if (this.getOriginalRequest().getRequestURI().equals(((Request)messageToTest).getRequestURI()) && (skipFromHeader || originalFromHeaderTag.equals(thisFromHeaderTag)) && (skipToHeader || originalToHeaderTag.equals(thisToHeaderTag)) && this.getOriginalRequest().getCallId().getCallId().equals(messageToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeqHeader().getSequenceNumber() == messageToTest.getCSeqHeader().getSequenceNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() throws IOException {
        if (this.getState() == -1 || this.getState() == 1) {
            if (this.isInviteTransaction() && !this.isMapped) {
                this.isMapped = true;
                new SendTrying(this);
            } else {
                this.isMapped = true;
            }
        }
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(Request transactionRequest, MessageChannel sourceChannel) throws SIPServerException {
        block31: {
            boolean toTu = false;
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("[ServerTransaction] processRequest: " + transactionRequest.getFirstLine() + "[" + this.getState() + "]");
            }
            try {
                if (this.getState() == -1) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage(32, "[ServerTransaction] Initializing transaction with original request");
                    }
                    this.setOriginalRequest(transactionRequest);
                    this.setState(1);
                    this.setPassToListener();
                    toTu = true;
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && 4 == this.getState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(5);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            if (this.lastResponse != null && this.lastResponse.getStatusCode() == 487) {
                                this.setState(6);
                            } else {
                                this.enableTimeoutTimer(7);
                            }
                        } else {
                            this.setState(6);
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (this.getState() == 3 || this.getState() == 4) {
                            if (this.lastResponse != null) {
                                try {
                                    this.getMessageChannel().sendMessage(this.lastResponse);
                                }
                                catch (IOException e) {
                                    this.setState(6);
                                    throw e;
                                }
                            }
                        } else if (transactionRequest.getMethod().equals("ACK")) {
                            this.requestOf.processRequest(transactionRequest, this);
                        }
                        return;
                    }
                }
                if (4 != this.getState() && 5 != this.getState() && 6 != this.getState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, this);
                        }
                    } else {
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                    break block31;
                }
                if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && this.getState() == 6 && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    if (!this.getDialog().ackSeen) {
                        this.getDialog().ackReceived(transactionRequest);
                        this.requestOf.processRequest(transactionRequest, this);
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Too late to cancel Transaction");
                    }
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("Dropping request " + this.getState());
                }
            }
            catch (IOException e) {
                this.raiseErrorEvent(2);
            }
        }
    }

    public void sendMessage(Message messageToSend) throws IOException {
        Response transactionResponse = (Response)messageToSend;
        int statusCode = transactionResponse.getStatusCode();
        if (this.getBranch() != null) {
            transactionResponse.getTopmostVia().setBranch(this.getBranch());
        } else {
            transactionResponse.getTopmostVia().removeParameter("branch");
        }
        if (!transactionResponse.getCSeqHeader().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendSIPResponse(transactionResponse);
            return;
        }
        if (this.dialog != null) {
            if (this.dialog.getRemoteTag() == null && transactionResponse.getTo().getTag() != null && ((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeqHeader().getMethod())) {
                this.dialog.setRemoteTag(transactionResponse.getTo().getTag());
                ((SIPTransactionStack)this.getSIPStack()).putDialog(this.dialog);
                if (statusCode / 100 == 1) {
                    this.dialog.setState(1);
                }
            } else if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(transactionResponse.getCSeqHeader().getMethod())) {
                if (Response.isSuccessfulResponse(statusCode)) {
                    if (!this.isInviteTransaction()) {
                        this.dialog.setState(2);
                    } else if (this.dialog.getState() == -1) {
                        this.dialog.setState(1);
                    }
                } else if (statusCode >= 300 && statusCode <= 699 && (this.dialog.getState() == -1 || this.dialog.getState() == 1)) {
                    this.dialog.setState(4);
                }
            } else if (transactionResponse.getCSeqHeader().getMethod().equals("BYE") && Response.isSuccessfulResponse(statusCode)) {
                if (!this.isReliable()) {
                    this.dialog.setState(3);
                } else {
                    this.dialog.setState(4);
                }
            }
        }
        if (this.getState() == 1) {
            if (statusCode / 100 == 1) {
                this.setState(3);
            } else if (Response.isFinalResponse(statusCode)) {
                if (!this.isInviteTransaction()) {
                    if (!this.isReliable()) {
                        this.setState(4);
                        this.enableTimeoutTimer(64);
                    } else {
                        this.setState(6);
                    }
                } else if (Response.isSuccessfulResponse(statusCode)) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.setState(6);
                    if (this.dialog != null) {
                        this.dialog.setRetransmissionTicks();
                    }
                } else {
                    this.setState(4);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                }
            }
        } else if (this.getState() == 3) {
            if (this.isInviteTransaction()) {
                if (Response.isSuccessfulResponse(statusCode)) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.setState(6);
                    if (this.dialog != null) {
                        this.dialog.setRetransmissionTicks();
                    }
                } else if (300 <= statusCode && statusCode <= 699) {
                    this.setState(4);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                this.setState(4);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(6);
                }
            }
        } else if (this.getState() == 4) {
            return;
        }
        try {
            this.lastResponse = transactionResponse;
            this.sendSIPResponse(transactionResponse);
        }
        catch (IOException e) {
            this.setState(6);
            this.collectionTime = 0;
            throw e;
        }
    }

    public String getViaHost() {
        return this.encapsulatedChannel.getViaHost();
    }

    public int getViaPort() {
        return this.encapsulatedChannel.getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.isInviteTransaction() && ((SIPTransactionStack)this.getSIPStack()).retransmissionFilter) {
                this.getMessageChannel().sendMessage(this.lastResponse);
            }
        }
        catch (IOException e) {
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("ServerTransaction.fireTimeoutTimer " + this.getState() + " method = " + this.getOriginalRequest().getMethod());
        }
        Dialog dialog = this.getDialog();
        int mystate = this.getState();
        if (((SIPTransactionStack)this.getSIPStack()).isDialogCreated(this.getOriginalRequest().getMethod()) && (mystate == 2 || mystate == 1)) {
            dialog.setState(4);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && dialog != null) {
            dialog.setState(4);
        }
        if ((this.getState() == 5 || this.getState() == 4) && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(6);
        } else if (!(this.isInviteTransaction() || this.getState() != 4 && this.getState() != 5)) {
            this.setState(6);
        } else if (this.isInviteTransaction() && this.getState() == 6) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(4);
            }
        }
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(Request originalRequest) {
        super.setOriginalRequest(originalRequest);
        if (originalRequest.getMethod().equals("ACK")) {
            this.setState(6);
        }
    }

    public void sendResponse(Response response) throws SipException {
        try {
            String fromTag;
            Dialog dialog = this.getDialog();
            Response responseImpl = response;
            if (responseImpl.getStatusCode() == 200 && this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod()) && dialog.getLocalTag() == null && responseImpl.getTo().getTag() == null) {
                throw new SipException("ToHeader tag must be set for OK");
            }
            if (responseImpl.getStatusCode() == 200 && responseImpl.getCSeqHeader().getMethod().equals("INVITE") && responseImpl.getHeader("Contact") == null) {
                throw new SipException("Contact Header is mandatory for the OK");
            }
            if (dialog == null && this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod()) && responseImpl.getStatusCode() < 299) {
                dialog = new Dialog(this);
                dialog.addRoute(this.getOriginalRequest());
                this.dialog = dialog;
            }
            if (dialog != null && dialog.getLocalTag() != null) {
                responseImpl.getTo().setTag(dialog.getLocalTag());
            }
            if ((fromTag = this.getRequest().getFromHeader().getTag()) != null) {
                responseImpl.getFromHeader().setTag(fromTag);
            } else if (LogWriter.needsLogging) {
                LogWriter.logMessage("WARNING -- Null From tag  Dialog layer in jeopardy!!");
            }
            if (responseImpl.getViaHeaders() == null) {
                responseImpl.setVia(this.getRequest().getViaHeaders());
            }
            this.sendMessage(response);
            if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "CANCEL") && responseImpl.getStatusCode() == 200 && this.parentStack.isDialogCreated(this.getOriginalRequest().getMethod()) && (dialog.getState() == -1 || dialog.getState() == 1)) {
                dialog.setState(4);
            }
            if (dialog != null) {
                dialog.printTags();
                if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "BYE")) {
                    dialog.setState(4);
                } else if (Utils.equalsIgnoreCase(responseImpl.getCSeqHeader().getMethod(), "CANCEL")) {
                    if (dialog.getState() == -1 || dialog.getState() == 1) {
                        dialog.setState(4);
                    }
                } else if (dialog.getLocalTag() == null && responseImpl.getTo().getTag() != null) {
                    if (responseImpl.getStatusCode() != 100) {
                        dialog.setLocalTag(responseImpl.getTo().getTag());
                    }
                    if (this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod())) {
                        if (response.getStatusCode() / 100 == 1) {
                            dialog.setState(1);
                        } else if (response.getStatusCode() / 100 == 2) {
                            dialog.setState(2);
                        }
                        if (responseImpl.getStatusCode() != 100) {
                            this.parentStack.putDialog(dialog);
                        }
                    }
                } else if (response.getStatusCode() / 100 == 2 && this.parentStack.isDialogCreated(responseImpl.getCSeqHeader().getMethod())) {
                    dialog.setState(2);
                    this.parentStack.putDialog(dialog);
                }
            }
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    class SendTrying
    extends Thread {
        ServerTransaction myTransaction;

        public SendTrying(ServerTransaction transaction) {
            this.myTransaction = transaction;
            Thread myThread = new Thread(this);
            myThread.start();
        }

        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.myTransaction.getState() == 1) {
                try {
                    this.myTransaction.sendMessage(this.myTransaction.getOriginalRequest().createResponse(100, "Trying"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

