/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite.header;

import java.util.Calendar;
import sip4me.gov.nist.core.GenericObject;
import sip4me.gov.nist.core.NameValueList;

public abstract class Header
extends GenericObject {
    public static final String ERROR_INFO = "Error-Info";
    public static final String MIME_VERSION = "Mime-Version";
    public static final String IN_REPLY_TO = "In-Reply-To";
    public static final String ALLOW = "Allow";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CALL_INFO = "Call-Info";
    public static final String CSEQ = "CSeq";
    public static final String ALERT_INFO = "Alert-Info";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CONTACT = "Accept-Contact";
    public static final String ENCRYPTION = "Encryption";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String RECORD_ROUTE = "Record-Route";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TO = "To";
    public static final String VIA = "Via";
    public static final String FROM = "From";
    public static final String CALL_ID = "Call-Id";
    public static final String AUTHORIZATION = "Authorization";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String SERVER = "Server";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String HIDE = "Hide";
    public static final String ROUTE = "Route";
    public static final String CONTACT = "Contact";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORGANIZATION = "Organization";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String REQUIRE = "Require";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String SUBJECT = "Subject";
    public static final String USER_AGENT = "User-Agent";
    public static final String WARNING = "Warning";
    public static final String PRIORITY = "Priority";
    public static final String DATE = "Date";
    public static final String EXPIRES = "Expires";
    public static final String SESSION_EXPIRES = "Session-Expires";
    public static final String MIN_SESSION_EXPIRES = "Min-SE";
    public static final String RESPONSE_KEY = "Response-Key";
    public static final String WARN_AGENT = "Warn-Agent";
    public static final String SUPPORTED = "Supported";
    public static final String EVENT = "Event";
    public static final String P_ASSOCIATED_URI = "P-Associated-URI";
    public static final String P_PREFERRED_IDENTITY = "P-Preferred-Identity";
    public String headerName;
    public String headerValue;

    public Header() {
    }

    public Header(String headerName) {
        this.headerName = headerName;
    }

    public Header(String headerName, String headerValue) {
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    public void setHeaderName(String name) {
        this.headerName = name;
    }

    public void setHeaderValue(String value) {
        this.headerValue = value;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getName() {
        return this.headerName;
    }

    public String getHeaderValue() {
        return this.encodeBody();
    }

    public String encode() {
        return String.valueOf(this.headerName) + ":" + " " + this.encodeBody() + "\r\n";
    }

    public Object clone() {
        return this;
    }

    public static String encodeCalendar(Calendar date) {
        StringBuffer sbuf = new StringBuffer();
        int wkday = date.get(7);
        switch (wkday) {
            case 2: {
                sbuf.append("Mon");
                break;
            }
            case 3: {
                sbuf.append("Tue");
                break;
            }
            case 4: {
                sbuf.append("Wed");
                break;
            }
            case 5: {
                sbuf.append("Thu");
                break;
            }
            case 6: {
                sbuf.append("Fri");
                break;
            }
            case 7: {
                sbuf.append("Sat");
                break;
            }
            case 1: {
                sbuf.append("Sun");
                break;
            }
            default: {
                new Exception("bad day of week?? Huh?? " + wkday).printStackTrace();
                return null;
            }
        }
        int day = date.get(5);
        if (day < 10) {
            sbuf.append(", 0" + day);
        } else {
            sbuf.append(", " + day);
        }
        sbuf.append(" ");
        int month = date.get(2);
        switch (month) {
            case 0: {
                sbuf.append("Jan");
                break;
            }
            case 1: {
                sbuf.append("Fedb");
                break;
            }
            case 2: {
                sbuf.append("Mar");
                break;
            }
            case 3: {
                sbuf.append("Apr");
                break;
            }
            case 4: {
                sbuf.append("May");
                break;
            }
            case 5: {
                sbuf.append("Jun");
                break;
            }
            case 6: {
                sbuf.append("Jul");
                break;
            }
            case 7: {
                sbuf.append("Aug");
                break;
            }
            case 8: {
                sbuf.append("Sep");
                break;
            }
            case 9: {
                sbuf.append("Oct");
                break;
            }
            case 10: {
                sbuf.append("Nov");
                break;
            }
            case 11: {
                sbuf.append("Dec");
                break;
            }
            default: {
                return null;
            }
        }
        sbuf.append(" ");
        int year = date.get(1);
        sbuf.append(year);
        sbuf.append(" ");
        int hour = date.get(11);
        if (hour < 10) {
            sbuf.append("0" + hour);
        } else {
            sbuf.append(hour);
        }
        sbuf.append(":");
        int min = date.get(12);
        if (min < 10) {
            sbuf.append("0" + min);
        } else {
            sbuf.append(min);
        }
        sbuf.append(":");
        int sec = date.get(13);
        if (sec < 10) {
            sbuf.append("0" + sec);
        } else {
            sbuf.append(sec);
        }
        sbuf.append(" GMT");
        return sbuf.toString();
    }

    public abstract NameValueList getParameters();

    public abstract Object getValue();

    protected abstract String encodeBody();

    public String toString() {
        return this.encode();
    }
}

