/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.siplite;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.microedition.sip.SipConnectionNotifierImpl;
import sip4me.gov.nist.siplite.EventScanner;
import sip4me.gov.nist.siplite.EventWrapper;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.ObjectInUseException;
import sip4me.gov.nist.siplite.SIPUtils;
import sip4me.gov.nist.siplite.SipEvent;
import sip4me.gov.nist.siplite.SipException;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.Timeout;
import sip4me.gov.nist.siplite.TimeoutEvent;
import sip4me.gov.nist.siplite.TransactionAlreadyExistsException;
import sip4me.gov.nist.siplite.TransactionUnavailableException;
import sip4me.gov.nist.siplite.address.Hop;
import sip4me.gov.nist.siplite.header.CallIdHeader;
import sip4me.gov.nist.siplite.header.RouteHeader;
import sip4me.gov.nist.siplite.header.ViaHeader;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.Dialog;
import sip4me.gov.nist.siplite.stack.MessageChannel;
import sip4me.gov.nist.siplite.stack.SIPTransactionErrorEvent;
import sip4me.gov.nist.siplite.stack.SIPTransactionEventListener;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.gov.nist.siplite.stack.Transaction;

public final class SipProvider
implements SIPTransactionEventListener {
    protected SipListener sipListener;
    protected SipStack sipStack;
    protected Hashtable listeningPoints;
    protected ServerTransaction currentTransaction;
    private EventScanner eventScanner;
    private SipConnectionNotifierImpl connectionNotifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws ObjectInUseException {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("Exiting provider " + this);
        }
        SipProvider sipProvider = this;
        synchronized (sipProvider) {
            Enumeration lpEnum = this.listeningPoints.elements();
            while (lpEnum.hasMoreElements()) {
                ListeningPoint listeningPoint = (ListeningPoint)lpEnum.nextElement();
                listeningPoint.removeSipProvider();
                this.listeningPoints.remove(listeningPoint);
                this.sipStack.deleteListeningPoint(listeningPoint);
            }
        }
        this.eventScanner = null;
    }

    public void handleEvent(SipEvent sipEvent, Transaction transaction) {
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("handleEvent " + sipEvent + "\ncurrentTransaction = " + transaction + "\nthis.sipListener = " + this.sipListener);
        }
        if (this.sipListener == null) {
            return;
        }
        EventWrapper eventWrapper = new EventWrapper();
        eventWrapper.sipEvent = sipEvent;
        eventWrapper.transaction = transaction;
        if (transaction != null && transaction instanceof ClientTransaction) {
            ((ClientTransaction)transaction).setEventPending();
        }
        this.eventScanner.addEvent(eventWrapper);
    }

    protected SipProvider(SipStack sipStack) {
        this.sipStack = sipStack;
        this.eventScanner = sipStack.eventScanner;
        this.listeningPoints = new Hashtable();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(SipListener sipListener) throws IllegalStateException {
        SipProvider provider;
        Enumeration it;
        SipStack sipStack = this.sipStack;
        synchronized (sipStack) {
            it = this.sipStack.getSipProviders();
            while (it.hasMoreElements()) {
                provider = (SipProvider)it.nextElement();
                if (provider.sipListener == null || provider.sipListener == sipListener) continue;
                throw new IllegalStateException("This SipProvider already has a listener associated to it!");
            }
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
        this.sipStack.sipListener = sipListener;
        sipStack = this.sipStack;
        synchronized (sipStack) {
            it = this.sipStack.getSipProviders();
            while (it.hasMoreElements()) {
                provider = (SipProvider)it.nextElement();
                provider.sipListener = sipListener;
            }
        }
    }

    public void addListeningPoint(ListeningPoint lp) throws ObjectInUseException {
        if (lp.sipProviderImpl != null && lp.sipProviderImpl != this) {
            throw new ObjectInUseException("Listening point assigned to another provider");
        }
        String transport = lp.getTransport().toUpperCase();
        if (this.listeningPoints.containsKey(transport) && this.listeningPoints.get(transport) != lp) {
            throw new ObjectInUseException("Listening point already assigned for transport!");
        }
        lp.sipProviderImpl = this;
        this.listeningPoints.put(transport, lp);
    }

    public ListeningPoint getListeningPoint(String transport) {
        if (transport == null) {
            throw new NullPointerException("Null transport param");
        }
        return (ListeningPoint)this.listeningPoints.get(transport.toUpperCase());
    }

    public ListeningPoint[] getListeningPoints() {
        ListeningPoint[] retval = new ListeningPoint[this.listeningPoints.size()];
        int i = 0;
        Enumeration lpEnum = this.listeningPoints.elements();
        while (lpEnum.hasMoreElements()) {
            retval[i++] = (ListeningPoint)lpEnum.nextElement();
        }
        return retval;
    }

    public void removeListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint.messageProcessor.inUse()) {
            throw new ObjectInUseException("Object is in use");
        }
        this.listeningPoints.remove(listeningPoint);
    }

    public CallIdHeader getNewCallId() {
        String callId = SIPUtils.generateCallIdentifier(this.getSipStack().getIPAddress());
        CallIdHeader callid = new CallIdHeader();
        callid.setCallId(callId);
        return callid;
    }

    /*
     * Unable to fully structure code
     */
    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        block22: {
            if (request == null) {
                throw new NullPointerException("null request");
            }
            sipRequest = request;
            if (sipRequest.getTransaction() != null) {
                throw new TransactionUnavailableException("Transaction already assigned to request");
            }
            if (request.getMethod().equals("CANCEL") && (ct = (ClientTransaction)this.sipStack.findInviteTransactionToCancel(request, false)) != null) {
                retval = this.sipStack.createClientTransaction(ct.getMessageChannel());
                retval.setOriginalRequest(request);
                retval.addEventListener(this);
                this.sipStack.addTransaction(retval);
                retval.setDialog(ct.getDialog());
                return retval;
            }
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("could not find existing transaction for " + request.getFirstLine());
            }
            dialogId = sipRequest.getDialogId(false);
            dialog = this.sipStack.getDialog(dialogId);
            it = null;
            if (dialog == null) {
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("could not find existing dialog for " + request.getFirstLine() + " and dialogID: " + dialogId);
                }
                it = this.sipStack.getRouter().getNextHops(request);
            }
            if (it != null && it.hasMoreElements()) ** GOTO lbl74
            if (dialog != null) {
                try {
                    hop = dialog.getNextHop();
                    if (hop != null) {
                        ct = (ClientTransaction)this.sipStack.createMessageChannel(hop);
                        branchId = SIPUtils.generateBranchId();
                        if (sipRequest.getTopmostVia() != null) {
                            sipRequest.getTopmostVia().setBranch(branchId);
                        } else {
                            messageProcessor = ((ListeningPoint)this.listeningPoints.get((Object)hop.getTransport().toUpperCase())).messageProcessor;
                            via = messageProcessor.getViaHeader();
                            sipRequest.addHeader(via);
                        }
                        ct.setOriginalRequest(sipRequest);
                        ct.setBranch(branchId);
                        ct.setNextHop(hop);
                        ct.setDialog(dialog);
                        ct.addEventListener(this);
                        return ct;
                    }
                    break block22;
                }
                catch (Exception ex) {
                    throw new TransactionUnavailableException(ex.getMessage());
                }
            }
            throw new TransactionUnavailableException("no route!");
lbl-1000:
            // 1 sources

            {
                hop = (Hop)it.nextElement();
                ct = (ClientTransaction)this.sipStack.createMessageChannel(hop);
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage("hop = " + hop + " ; ct " + ct + " for topmostVia: " + sipRequest.getTopmostVia());
                }
                if (ct == null) continue;
                branchId = SIPUtils.generateBranchId();
                if (sipRequest.getTopmostVia() != null) {
                    sipRequest.getTopmostVia().setBranch(branchId);
                } else {
                    messageProcessor = ((ListeningPoint)this.listeningPoints.get((Object)hop.getTransport().toUpperCase())).messageProcessor;
                    via = messageProcessor.getViaHeader();
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Creating via header: " + via + " for hop: " + hop);
                    }
                    sipRequest.addHeader(via);
                }
                ct.setOriginalRequest(sipRequest);
                ct.setBranch(branchId);
                ct.setNextHop(hop);
                if (this.sipStack.isDialogCreated(request.getMethod())) {
                    if (LogWriter.needsLogging) {
                        LogWriter.logMessage("Creating Client Transaction For Dialog-Initiating request (" + request.getMethod() + ")");
                    }
                    if (dialog != null) {
                        ct.setDialog(dialog);
                    } else {
                        this.sipStack.createDialog(ct);
                    }
                } else {
                    ct.setDialog(dialog);
                }
                ct.addEventListener(this);
                return ct;
lbl74:
                // 2 sources

                ** while (it.hasMoreElements())
            }
        }
        throw new TransactionUnavailableException("Could not create transaction - could not resolve next hop! ");
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        try {
            ServerTransaction transaction = null;
            Request sipRequest = request;
            if (this.sipStack.isDialogCreated(sipRequest.getMethod())) {
                if (this.sipStack.findTransaction(request, true) != null) {
                    throw new TransactionAlreadyExistsException("server transaction already exists!");
                }
                transaction = this.currentTransaction;
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available");
                }
                if (!transaction.isMessagePartOfTransaction(request)) {
                    throw new TransactionUnavailableException("Request Mismatch");
                }
                transaction.setOriginalRequest(sipRequest);
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Error sending provisional response");
                }
                transaction.addEventListener(this);
                String dialogId = sipRequest.getDialogId(true);
                Dialog dialog = this.sipStack.getDialog(dialogId);
                if (dialog == null) {
                    dialog = this.sipStack.createDialog(transaction);
                } else {
                    transaction.setDialog(dialog);
                }
                dialog.setStack(this.sipStack);
                dialog.addRoute(sipRequest);
                if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
                    this.sipStack.putDialog(dialog);
                }
            } else {
                transaction = (ServerTransaction)this.sipStack.findTransaction(request, true);
                if (transaction != null) {
                    throw new TransactionAlreadyExistsException("Transaction exists! ");
                }
                transaction = this.currentTransaction;
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available!");
                }
                if (!transaction.isMessagePartOfTransaction(request)) {
                    throw new TransactionUnavailableException("Request Mismatch");
                }
                transaction.setOriginalRequest(sipRequest);
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Could not send back provisional response!");
                }
                String dialogId = sipRequest.getDialogId(true);
                Dialog dialog = this.sipStack.getDialog(dialogId);
                if (dialog != null) {
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                }
            }
            return transaction;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void sendRequest(Request request) throws SipException {
        it = this.sipStack.getRouter().getNextHops(request);
        if (it == null || !it.hasMoreElements()) {
            throw new SipException("could not determine next hop!");
        }
        tr = this.sipStack.findTransaction(request, false);
        if (tr == null) ** GOTO lbl28
        throw new SipException("Cannot send statelessly Transaction found!");
lbl-1000:
        // 1 sources

        {
            nextHop = (Hop)it.nextElement();
            sipRequest = request;
            bid = sipRequest.getTransactionId();
            via = sipRequest.getTopmostVia();
            via.setBranch(bid);
            if (sipRequest.getHeader("Route") != null) {
                newRequest = (Request)sipRequest.clone();
                rl = newRequest.getHeaders("Route");
                route = (RouteHeader)rl.nextElement();
                newRequest.setRequestURI(route.getAddress().getURI());
                sipRequest.removeHeader("Route", true);
            } else {
                newRequest = sipRequest;
            }
            messageChannel = this.sipStack.createRawMessageChannel(nextHop);
            try {
                if (messageChannel != null) {
                    messageChannel.sendMessage(newRequest);
                    return;
                }
                throw new SipException("could not forward request");
            }
            catch (IOException var10_10) {
                // empty catch block
            }
lbl28:
            // 2 sources

            ** while (it.hasMoreElements())
        }
lbl29:
        // 1 sources

    }

    public void sendResponse(Response sipResponse) throws SipException {
        ViaHeader via;
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(16, "Sending response " + sipResponse.getFirstLine());
        }
        if ((via = sipResponse.getTopmostVia()) == null) {
            throw new SipException("No via header in response!");
        }
        int port = via.getPort();
        String transport = via.getTransport();
        String host = via.getReceived();
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Host from received: " + host + " is null? " + (host == null));
        }
        if (host == null) {
            System.out.println("Getting Host from Via, as received is null");
            host = via.getHost();
        }
        if (port == -1) {
            port = 5060;
        }
        if (LogWriter.needsLogging) {
            LogWriter.logMessage(32, "Response will be sent to Hop: " + host + ":" + port + "/" + transport);
        }
        Hop hop = new Hop(String.valueOf(host) + ":" + port + "/" + transport);
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            messageChannel.sendMessage(sipResponse);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPoint lp = listeningPoint;
        lp.sipProviderImpl = this;
        String transport = lp.getTransport().toUpperCase();
        try {
            if (this.listeningPoints.containsKey(transport) && this.listeningPoints.get(transport) != lp) {
                throw new ObjectInUseException("Listening point already assigned for transport!");
            }
            this.listeningPoints.put(lp.getTransport().toUpperCase(), lp);
        }
        catch (ObjectInUseException e) {
            e.printStackTrace();
        }
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        Transaction transaction = transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            if (LogWriter.needsLogging) {
                LogWriter.logMessage("TransportError occured on " + transaction);
            }
            Transaction errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof ServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject) : new TimeoutEvent(this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, errorObject);
        } else {
            Transaction errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof ServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject) : new TimeoutEvent(this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, errorObject);
        }
    }

    public SipConnectionNotifierImpl getConnectionNotifier() {
        return this.connectionNotifier;
    }

    public void setConnectionNotifier(SipConnectionNotifierImpl connectionNotifier) {
        this.connectionNotifier = connectionNotifier;
    }
}

