/*
 * Decompiled with CFR 0.152.
 */
package sip4me.gov.nist.microedition.sip;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.Vector;
import sip4me.gov.nist.core.LogWriter;
import sip4me.gov.nist.core.Utils;
import sip4me.gov.nist.microedition.sip.SipClientConnectionImpl;
import sip4me.gov.nist.microedition.sip.SipConnectionNotifierImpl;
import sip4me.gov.nist.siplite.ConfigurationProperties;
import sip4me.gov.nist.siplite.ListeningPoint;
import sip4me.gov.nist.siplite.ObjectInUseException;
import sip4me.gov.nist.siplite.RequestEvent;
import sip4me.gov.nist.siplite.ResponseEvent;
import sip4me.gov.nist.siplite.SipFactory;
import sip4me.gov.nist.siplite.SipListener;
import sip4me.gov.nist.siplite.SipProvider;
import sip4me.gov.nist.siplite.SipStack;
import sip4me.gov.nist.siplite.TimeoutEvent;
import sip4me.gov.nist.siplite.address.AddressFactory;
import sip4me.gov.nist.siplite.header.HeaderFactory;
import sip4me.gov.nist.siplite.message.MessageFactory;
import sip4me.gov.nist.siplite.message.Request;
import sip4me.gov.nist.siplite.message.Response;
import sip4me.gov.nist.siplite.stack.ClientTransaction;
import sip4me.gov.nist.siplite.stack.MessageProcessor;
import sip4me.gov.nist.siplite.stack.ServerTransaction;
import sip4me.nist.javax.microedition.sip.SipClientConnection;
import sip4me.nist.javax.microedition.sip.SipConnectionNotifier;
import sip4me.nist.javax.microedition.sip.SipDialog;

public class StackConnector
implements SipListener {
    private static StackConnector instance = null;
    protected SipStack sipStack = null;
    private String localAddress = "127.0.0.1";
    protected Vector connectionNotifiersList = new Vector();
    protected Vector sipDialogList = new Vector();
    public static AddressFactory addressFactory = null;
    public static MessageFactory messageFactory = null;
    public static HeaderFactory headerFactory = null;
    public static ConfigurationProperties properties = new ConfigurationProperties();
    private Timer stackTimer = new Timer();

    static {
        messageFactory = new MessageFactory();
        addressFactory = new AddressFactory();
        headerFactory = new HeaderFactory();
    }

    private StackConnector() throws IOException {
        SipFactory sipFactory = SipFactory.getInstance();
        this.localAddress = properties.getProperty("javax.sip.IP_ADDRESS");
        properties.setProperty("javax.sip.STACK_NAME", "sip-for-me");
        try {
            this.sipStack = sipFactory.createSipStack(properties);
            this.sipStack.setStackConnector(this);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private void dispose() {
        if (this.connectionNotifiersList != null) {
            this.connectionNotifiersList.removeAllElements();
        }
        this.connectionNotifiersList = null;
        if (this.sipDialogList != null) {
            this.sipDialogList.removeAllElements();
        }
        this.sipDialogList = null;
        if (this.stackTimer != null) {
            this.stackTimer.cancel();
        }
        this.stackTimer = null;
        this.sipStack = null;
        instance = null;
    }

    public static synchronized StackConnector getInstance() throws IOException {
        if (instance == null) {
            instance = new StackConnector();
            if (LogWriter.needsLogging) {
                LogWriter.logMessage(32, "Creating new instance of StackConnector " + instance);
            }
        }
        return instance;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public static synchronized void releaseInstance() {
        if (instance != null) {
            instance.dispose();
        }
        instance = null;
    }

    public SipConnectionNotifier createSipConnectionNotifier(int portNumber, boolean secure, Vector parameters) throws IOException {
        MessageProcessor msgProc;
        boolean onlyTCP = false;
        boolean onlyUDP = true;
        ListeningPoint udpLP = null;
        ListeningPoint tcpLP = null;
        SipProvider sipProvider = null;
        if (parameters != null) {
            Enumeration paramEnum = parameters.elements();
            while (paramEnum.hasMoreElements()) {
                String nextParam = (String)paramEnum.nextElement();
                if (!nextParam.equalsIgnoreCase("transport=tcp")) continue;
                onlyTCP = true;
                onlyUDP = false;
            }
        }
        if (!onlyTCP) {
            try {
                udpLP = this.sipStack.createListeningPoint(portNumber, "udp");
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "Listening point created on : " + this.localAddress + ":" + portNumber + "/" + udpLP.getTransport().toUpperCase());
                }
            }
            catch (IllegalArgumentException iae) {
                msgProc = this.sipStack.getMessageProcessor("udp");
                if (msgProc != null) {
                    this.sipStack.removeMessageProcessor(msgProc);
                }
                udpLP = null;
                throw new IOException(iae.getMessage());
            }
        }
        if (!onlyUDP) {
            try {
                tcpLP = this.sipStack.createListeningPoint(portNumber, "tcp");
                if (LogWriter.needsLogging) {
                    LogWriter.logMessage(32, "Listening point created on : " + this.localAddress + ":" + portNumber + "/" + tcpLP.getTransport().toUpperCase());
                }
            }
            catch (IllegalArgumentException iae) {
                if (udpLP != null) {
                    try {
                        this.sipStack.deleteListeningPoint(udpLP);
                    }
                    catch (ObjectInUseException e) {
                        e.printStackTrace();
                    }
                    udpLP = null;
                }
                if ((msgProc = this.sipStack.getMessageProcessor("tcp")) != null) {
                    this.sipStack.removeMessageProcessor(msgProc);
                }
                tcpLP = null;
                throw new IOException(iae.getMessage());
            }
            try {
                sipProvider = this.sipStack.createSipProvider(tcpLP);
            }
            catch (ObjectInUseException oiue) {
                throw new IOException(oiue.getMessage());
            }
        }
        if (udpLP != null) {
            try {
                if (sipProvider == null) {
                    sipProvider = this.sipStack.createSipProvider(udpLP);
                } else {
                    sipProvider.addListeningPoint(udpLP);
                }
            }
            catch (ObjectInUseException oiue) {
                throw new IOException(oiue.getMessage());
            }
        }
        try {
            sipProvider.addSipListener(this);
        }
        catch (IllegalStateException ise) {
            throw new IOException(ise.getMessage());
        }
        SipConnectionNotifierImpl sipConnectionNotifier = new SipConnectionNotifierImpl(sipProvider, this.localAddress, portNumber);
        sipProvider.setConnectionNotifier(sipConnectionNotifier);
        this.connectionNotifiersList.addElement(sipConnectionNotifier);
        return sipConnectionNotifier;
    }

    public SipClientConnection createSipClientConnection(String scheme, String user, String host, int portNumber, Vector parameters) {
        SipClientConnectionImpl sipClientConnection = new SipClientConnectionImpl(scheme, user, host, portNumber, parameters);
        return sipClientConnection;
    }

    protected static String generateTag() {
        return Utils.generateTag();
    }

    protected SipDialog findDialog(String dialogID) {
        Enumeration e = this.sipDialogList.elements();
        while (e.hasMoreElements()) {
            SipDialog sipDialog = (SipDialog)e.nextElement();
            if (sipDialog.getDialogID() == null || !sipDialog.getDialogID().equals(dialogID)) continue;
            return sipDialog;
        }
        return null;
    }

    public void processRequest(RequestEvent requestEvent) {
        try {
            Request request = requestEvent.getRequest();
            SipConnectionNotifierImpl sipConnectionNotifier = null;
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction != null) {
                sipConnectionNotifier = (SipConnectionNotifierImpl)serverTransaction.getApplicationData();
            }
            if (sipConnectionNotifier == null) {
                SipProvider sipProvider = (SipProvider)requestEvent.getSource();
                sipConnectionNotifier = sipProvider.getConnectionNotifier();
                if (serverTransaction != null) {
                    serverTransaction.setApplicationData(sipConnectionNotifier);
                }
            }
            if (sipConnectionNotifier != null) {
                sipConnectionNotifier.notifyRequestReceived(request);
            } else {
                new RuntimeException("we cannot find any connection notifiermatching to handle this request").printStackTrace();
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        try {
            Response response = responseEvent.getResponse();
            ClientTransaction clientTransaction = responseEvent.getClientTransaction();
            SipClientConnectionImpl sipClientConnection = (SipClientConnectionImpl)clientTransaction.getApplicationData();
            if (sipClientConnection != null) {
                sipClientConnection.notifyResponseReceived(response);
            } else {
                new RuntimeException("we cannot find any client connectionmatching to handle this request").printStackTrace();
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
    }

    protected Timer getStackTimer() {
        return this.stackTimer;
    }
}

