<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_acp_user_delete extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','acp');
  XFUI::load_lang_res('','register');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('member_list'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $uid = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $keep = XF::sanitize_var(XF::ifset($input,'k',0),'str','okifempty,forcestr');
  $confirm = XF::sanitize_var(XF::ifset($input,'c',0),'str','okifempty,forcestr');
  $this->gpc = array('user'=>$uid,'keep_post'=>$keep,'confirm'=>$confirm);
  }

  /**
  * delete an existing user account
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  $gu = XF::get_cfg('main_guest_uid');
    try {
    $susr = XF::sql_query("SELECT u_id,u_name FROM ".XF::tbl('user')." WHERE u_id = :userid",
    array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( !is_object($userdata) )
      $this->error = '{:invalid_username}';
      if ( $userdata->u_id === XF::vault_query('current_user_id') && empty($this->error) )
      $this->error = '{:invalid_username}';
      if ( (bool)$this->gpc['confirm'] === false && empty($this->error) )
      $this->error = '{:delete_not_confirmed}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('acl'=>'w','post_data'=>'w','post_meta'=>'w','post_rating'=>'w','user'=>'w','user_blacklist'=>'w','user_bookmark'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      XF::tpl_use_cache_pool(1,'begin');
      $stop = XF::sql_query("SELECT DISTINCT(p_topic_id) AS p_topic_id FROM ".XF::tbl('post_meta')." WHERE p_u_id = :userid",
      array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
        while ( $r = $stop->fetchObject() ){
        $cache = XFCache::topic($r->p_topic_id);
        $nulled = false;
          foreach ( $cache['user'] as $k=>$v ){
            if ( is_numeric($k) && $v === $this->gpc['user'] ){

              if ( (bool)$this->gpc['keep_post'] ){
              XFCache::topic_delta($cache,'change_user',array('id'=>$k,'user'=>$gu));
              XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_u_id = :userid WHERE p_id = :postid",array(
              'postid'=>array($k,'int'),
              'userid'=>array($gu,'int')),__METHOD__,__LINE__);
              }
              else{ // do not keep posts...
                if ( $cache['user'][(int)$r->p_topic_id] === $this->gpc['user'] ){
                  foreach ( $cache['tree'] as $k2=>$v2 ){
                  XF::sql_query("DELETE FROM ".XF::tbl('post_meta')." WHERE p_id = :postid",array('postid'=>array($k2,'int')),__METHOD__,__LINE__);
                  XF::sql_query("DELETE FROM ".XF::tbl('post_data')." WHERE pd_p_id = :postid",array('postid'=>array($k2,'int')),__METHOD__,__LINE__);
                  }
                $nulled = true;
                break;
                }
                else{
                XFCache::topic_delta($cache,'remove_reply',array('id'=>$k));
                XF::sql_query("DELETE FROM ".XF::tbl('post_meta')." WHERE p_id = :postid",array('postid'=>array($k,'int')),__METHOD__,__LINE__);
                XF::sql_query("DELETE FROM ".XF::tbl('post_data')." WHERE pd_p_id = :postid",array('postid'=>array($k,'int')),__METHOD__,__LINE__);
                }
              }

            XF::tpl_use_cache_pool($k,'change');
              if ( XF::$tpl->is_cached('post.tpl',$k) )
              XF::$tpl->clear_cache('post.tpl',$k);
            }
          }

          if ( $nulled )
          XFCache::purge('topic',$r->p_topic_id);
          else
          XFCache::put('topic',$r->p_topic_id,$cache);

        }
      $stop->closeCursor();
      XF::tpl_use_cache_pool(0,'reset');

      XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_edit_u_id = :guestid WHERE pd_edit_u_id = :userid",array('userid'=>array($this->gpc['user'],'int'),'guestid'=>array($gu,'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('acl')." WHERE a_key = :userid AND a_use_group = false",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('log')." WHERE l_u_id = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('post_rating')." WHERE pr_u_id = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user')." WHERE u_id = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_src = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_blacklist')." WHERE ub_u_id_dst = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_bookmark')." WHERE uk_u_id = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_u_id = :userid",array('userid'=>array($this->gpc['user'],'int')),__METHOD__,__LINE__);
      XF::logger('info','userid',$this->gpc['user'],'username',$userdata->u_name,'keep_post',XF::bool2yn((bool)$this->gpc['keep_post']));
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_acp_user_delete($input){
  $a = new XFAction_acp_user_delete();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('member_list'),'{:account_successfully_deleted}');
    else
    return xfaf_failure($a->get_error());
  }

?>