<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFUI class handles user interface methods
* @package lbcore
*/
class XFUI {
/**
* @var integer topics having less than x pages get a 'full' page nabvar
*/
const COMPACT_PAGEBAR_THRESHOLD = 8;
/**
* @var resource main instance for asynchronous requests
*/
protected static $ajax_main = null;
/**
* @var resource response instance for asynchronous requests
*/
public static $ajax_response = null;
/**
* @var string compiled head segments for html to serve asynchronous requests
*/
public static $ajax_head = '';

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * output html header
  * @param string $title title text
  * @param string $aux additional text for title line in html head segment
  * @return boolean
  * @since 1.0.0
  */
  public static function html_head($title,$aux = ''){
    if ( defined('__XF_SENT_HEADER') )
    return false;
    try {
      if ( !XF::$tpl instanceof Smarty )
      throw new XFE('template engine is not initialized');
    $cssdef = '';
    $user = XF::get_user();
    $tl = ( isset($_SESSION['xf_authentication']['time']) )
    ? ($_SESSION['xf_authentication']['time']+XF::get_cfg('auth_max_lifetime'))-XF::vault_query('uts')
    : '';
      if ( is_integer($tl) && $tl > 3600 )
      $tl = round($tl/3600,1).' '.self::i18n('hours');
      elseif ( is_integer($tl) && $tl <= 3600 && $tl > 0 )
      $tl = round($tl/60,0).' '.self::i18n('minutes');
      elseif ( is_integer($tl) && $tl <= 0 )
      $tl = self::i18n('expired');
    $fingerprint = substr(XF::vault_query('request_action'),0,4);
      if ( $fingerprint === 'acp_' )
      $navbar = 'acp';
      elseif ( $fingerprint === 'mcp_' )
      $navbar = 'mcp';
      else
      $navbar = 'std';
      foreach ( XF::$style['stylesheet'] as $v ){
      $v = explode(',',$v);
        switch ( $v[0] ){
        case 'AUTO': $cssdef .= '<link rel="stylesheet" href="'.$v[2].'" media="'.str_replace('|',',',$v[1]).'" charset="utf-8"></link>'.chr(10); break;
        case 'CIE6': $cssdef .= '<!--[if IE 6]><link rel="stylesheet" href="'.$v[2].'" media="'.str_replace('|',',',$v[1]).'" charset="utf-8"></link><![endif]-->'.chr(10); break;
        case 'CIE7': $cssdef .= '<!--[if IE 7]><link rel="stylesheet" href="'.$v[2].'" media="'.str_replace('|',',',$v[1]).'" charset="utf-8"></link><![endif]-->'.chr(10); break;
        default: break;
        }
      }

    $au = ( defined('__XF_ANNOY_THIS_BASTARD') ) ? true : false;
    $cachehandler = crc32($navbar.(int)XF::vault_query('is_logged_in').(int)$au);
    //XF::$tpl->clear_cache('common_head.tpl',$cachehandler);
    XF::$tpl->assign('headline',self::lang_str($title));
    $title = XF::get_cfg('main_title').' - '.self::lang_str($title);
      if ( !empty($aux) )
      $title .= ' - '.$aux;
    XF::$tpl->assign('title',$title);
    XF::$tpl->assign('login_time',$tl);
    XF::$tpl->assign('debug_mode',(XF::DEBUG)?'true':'false');
    XF::$tpl->assign('stylesheets',rtrim($cssdef));
    XF::$tpl->assign('uri_css',XF::get_cfg('uri_css'));
    XF::$tpl->assign('uri_js',XF::get_cfg('uri_js'));
    XF::$tpl->assign('language',XF::vault_query('current_language'));
    XF::$tpl->assign('style',XF::vault_query('current_style'));
    XF::$tpl->assign('user_name',$user['u_name']);
    XF::$tpl->assign('show_executive',(XF::access_control('acp_overview'))?'true':'false');
    XF::$tpl->assign('show_moderator',(XF::access_control('mcp_overview'))?'true':'false');
    XF::$tpl->assign('post_maximum_length',(int)XF::POST_MAXLEN);
      if ( !XF::$tpl->is_cached('common_head.tpl',$cachehandler) ){
      XF::$tpl->assign('site_name',XF::get_cfg('main_title'));
      XF::$tpl->assign('navbar',$navbar);
      XF::$tpl->assign('is_logged_in',(int)XF::vault_query('is_logged_in'));
      XF::$tpl->assign('annoy_user',$au);
      }
    XF::$tpl->display('common_head.tpl',$cachehandler);
    XF::reset_tpl();
    define('__XF_SENT_HEADER',1);
    } catch ( XFE $E ){ $E->handle(); }
  return true;
  }

  /**
  * output html footer
  * @return boolean
  * @since 1.0.0
  */
  public static function html_foot(){
    if ( defined('__XF_SENT_FOOTER') )
    return false;
    try {
      if ( !defined('__XF_SENT_HEADER') )
      self::html_head('');
      if ( !XF::$tpl instanceof Smarty )
      throw new XFE('template engine is not initialized');
    $time = new DateTime('now',new DateTimeZone(XF::vault_query('current_timezone')));
    $time = round($time->getOffset()/3600,2);
    $time = ( $time >= 0 ) ? '+'.$time : strval($time);
    XF::$tpl->clear_cache('common_foot.tpl');
    XF::$tpl->assign('style',XF::vault_query('current_style'));
    XF::$tpl->assign('timezone',XF::vault_query('current_timezone').' ('.$time.')');
    XF::$tpl->assign('database_connection',(is_null(XF::$sql))?false:true);
    XF::$tpl->assign('scheduled_task_run',(defined('__XF_TASK_RUN'))?__XF_TASK_RUN:false);
    XF::$tpl->assign('script_runtime',round(microtime(true)-XF::vault_query('bench'),3));
    XF::$tpl->assign('annoy_user',(defined('__XF_ANNOY_THIS_BASTARD'))?XF::token(16,'alnum'):false);
    XF::$tpl->assign('debug_mode',(int)XF::DEBUG);
    XF::$tpl->display('common_foot.tpl');
    XF::reset_tpl();
    define('__XF_SENT_FOOTER',1);
    } catch ( XFE $E ){ $E->handle(); }
  return true;
  }

  /**
  * output a redirection. if you pass an uri directly (instead of XF::link()), ensure it's "urlencoded"!
  * @param integer $class operation was a success '1', a failure '0' or redirect silently '-1'
  * @param string $uri full destination uri (correctly encoded!)
  * @param string $msg message to show, if class is not '-1'
  * @return void
  * @since 1.0.0
  */
  public static function html_redirect($class,$uri,$msg = ''){ // class: -1 force redirect by http, 0 failed, 1 success
  $location = ( preg_match('/(Windows|Xitami)/i',XF::sanitize_var(XF::ifset('server','SERVER_SOFTWARE',''),'str')) ) ? 'Refresh: 0;URL= ' : 'Location: ';
  $qs = strpos($uri,'?'); // clean the query_string...
  $uri = substr($uri,0,$qs).preg_replace('/([\x00-\x1f]+|%[00-1f]{1,2})/iu','',substr($uri,$qs));
    if ( $class === -1 && !headers_sent() ){
    header($location.str_replace('&amp;','&',$uri));
    die();
    }
    if ( XF::$tpl instanceof Smarty ){
    self::html_head('{:redirection}');
    XF::$tpl->clear_cache('common_redirect.tpl');
    XF::$tpl->assign('success',(bool)$class);
    XF::$tpl->assign('uri',$uri);
    XF::$tpl->assign('message',self::lang_str($msg));
    XF::$tpl->display('common_redirect.tpl');
    XF::reset_tpl();
    self::html_foot();
    die();
    }
    else{
    header($location.str_replace('&amp;','&',$uri));
    die();
    }
  }

  /**
  * init ajax engine. if you want to use it, call it before(!) html_head()
  * @return true
  * @since 1.0.0
  */
  public static function ajax_init(){
  $reg = array();
    try {
      if ( defined('__XF_SENT_HEADER') )
      throw new XFE('this method must be called before html_head()');
      if ( !is_null(self::$ajax_main) )
      throw new XFE('cannot instantiate ajax class more than once');
    require_once(XF::vault_query('root_path').'/ext/xajax/xajax.inc.php');
    self::$ajax_main = new xajax(XF::get_cfg('param_ajax'));
    self::$ajax_main->setCharEncoding('utf-8');
    self::$ajax_main->setFlag('debug',false);
    self::$ajax_main->setFlag('waitCursor',true);
    self::$ajax_main->setFlag('errorHandler',false);
    self::$ajax_main->setFlag('statusMessages',true);
    self::$ajax_main->configure('errorHandler',false);
    self::$ajax_main->registerFunction('xf__handler');
    self::$ajax_main->processRequest();
    self::$ajax_head = self::$ajax_main->getJavascript(XF::get_cfg('uri_js').'/ext');
    } catch ( XFE $E ){ $E->handle(); }
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,implode(',',$reg));
  return true;
 }

  /**
  * load a language namespace and cache it locally
  * @param string $rlang name of language (i.e. 'en')
  * @param string $namespace and its namespace (i.e. 'core')
  * @return true
  * @since 1.0.0
  */
  public static function load_lang_res($rlang,$namespace){
    if ( empty($rlang) )
    $rlang = XF::vault_query('current_language');
    try {
    $rlang = XF::sanitize_var($rlang,'lang');
    $namespace = preg_replace('/[^a-z]+/u','',$namespace);
      if ( !$rlang )
      throw new XFE('illegal language');
    } catch ( XFE $E ){ $E->handle(); }
  $lang = array();
  require_once(XF::vault_query('root_path').'/lang/'.$rlang.'/'.$namespace.'.php');
    if ( !isset(XF::$lang[$rlang]) )
    XF::$lang[$rlang] = array();
    if ( XF::DEBUG ){ // list any redeclared keys...
    $rd = array_keys(array_intersect_key(XF::$lang[$rlang],$lang));
    $a = array();
      foreach ( $rd as $v )
      $a[] = chr(10).'key:'.$v.chr(10).'-"'.XF::$lang[$rlang][$v].'"'.chr(10).'+"'.$lang[$v].'"'.chr(10);
      if ( sizeof($rd) > 0 )
      D($a,$rlang.'.'.$namespace.' redeclared following language keys');
    unset($a,$v,$rd);
    }
  $d = sizeof(XF::$lang[$rlang]);
  XF::$lang[$rlang] = array_merge(XF::$lang[$rlang],$lang);
  $d = sizeof(XF::$lang[$rlang])-$d;
    if ( substr($d,0,1) !== '-' )
    $d = '+'.$d;
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,implode(',',array($rlang,$namespace,$d)));
  return true;
  }

  /**
  * do a translation request like '{[LANGUAGE]:STRING_IDENTIFIER}'
  * @param string $a input stream
  * @param boolean $b if 'true', missing string identifier will result in error message
  * @return string
  * @since 1.0.0
  */
  public static function lang_str($a,$b = true){
  $c = array();
  $d = ( substr($a,0,2) === '{:' ) ? true : false;
    if ( !$d )
    return $a;
  $c[1] = substr($a,1,$d-1);
  $c[2] = substr($a,$d+1,-1);
  $c = self::i18n($c[2],$c[1]);
    if ( !$b && substr($c,0,16) === '{{LANG_STR_MISS(' )
    $c = '???';
  return $c;
  }

  /**
  * fetch a string from translation table
  * @param string $a string key
  * @param string $b selected language
  * @return string
  * @since 1.0.0
  */
  public static function i18n($a,$b = ''){
  static $cl = null;
    if ( is_null($cl) )
    $cl = XF::vault_query('current_language');
    if ( (bool)$b === false || strlen($b) < 2 )
    $b = $cl;
  return ( isset(XF::$lang[$b][$a]) ) ? XF::$lang[$b][$a] : '{{LANG_STR_MISS('.$a.')}}';
  }

  /**
  * fetch an image from imageset
  * @param string $a string key
  * @return string
  * @since 1.0.0
  */
  public static function image($a){
  $a = strtolower($a);
  return ( isset(XF::$style['imageset'][$a]) ) ? XF::$style['imageset'][$a] : XF::$style['imageset']['icon_missing'];
  }

  /**
  * check whether the selected user has access to a topic or not
  * @param array $cache returned resource from XFCache::topic()
  * @param array $prefix returned resource from XFUI::get_post_prefix_list()
  * @param integer $uid user id, current if not given
  * @param integer $gid group id, current if not given
  * @return boolean
  * @since 1.0.0
  */
  public static function topic_access(&$cache,&$prefix,$uid = 0, $gid = 0){
  static $init = false;
  static $data = array('MOD'=>array(),'EXEC'=>array(),'OWNER'=>'');
  $pacl = ( isset($prefix[$cache['attr']['prefix']]) ) ? $prefix[$cache['attr']['prefix']]['pp_preset_acl'] : '';
  $acl = ( isset($cache['attr']['acl']) ) ? $cache['attr']['acl'] : '';
    if ( !empty($pacl) )
    $acl = $pacl;
    if ( empty($acl) || $acl === '{$ALL}' )
    return true;
    if ( $acl === '{$NONE}' )
    return false;
  $data['OWNER'] = ( isset($cache['topicid']) && isset($cache['user'][$cache['topicid']]) ) ? $cache['user'][$cache['topicid']] : XF::vault_query('current_user_id');
  unset($pacl);

    if ( !$init ){ // cache some data on first run...
    $modlist = XFCache::get('acl',crc32('mcp_overview'));
      if ( !is_array($modlist) ){
      $modlist = array();
      $smod = XF::sql_query("SELECT a_key,a_use_group,a_allow FROM ".XF::tbl('acl')." WHERE a_action = 'mcp_overview'",'',__METHOD__,__LINE__);
        while ( $r = $smod->fetchObject() )
        $modlist[] = (array)$r;
      $smod->closeCursor();
      }
      foreach ( $modlist as $v ){
        if ( !isset($v['a_key']) || !isset($v['a_use_group']) || !isset($v['a_allow']) )
        continue;
        if ( (bool)$v['a_use_group'] && (bool)$v['a_allow'] )
        $data['MOD'][] = '@'.intval($v['a_key']);
      }
    $g = XF::get_group('*');
      foreach ( $g as $v ){
        if ( $v['g_executive'] )
        $data['EXEC'][] = '@'.intval($v['g_id']);
      }
    $init = true;
    unset($modlist);
    }

  $acl = explode(',',$acl);
    if ( !$uid )
    $uid = XF::vault_query('current_user_id');
    if ( !$gid )
    $gid = XF::vault_query('current_group_id');

    foreach ( $acl as $v ){
    $a = array();
      switch ( $v ){
      case '{$MODERATOR}': $a = $data['MOD']; break;
      case '{$EXECUTIVE}': $a = $data['EXEC']; break;
      case '{$OWNER}': $a[] = $data['OWNER']; break;
      default: $a[] = $v; break;
      }
      foreach ( $a as $v ){
        if ( substr($v,0,1) === '@' && intval(substr($v,1)) === (int)$gid )
        return true;
        if ( intval($v) === (int)$uid )
        return true;
      }
    }

  return false;
  }

  /**
  * fetch any posting prefixes and cache it
  * @param boolean $strict if 'true', it returns only prefixes without access restrictions
  * @return array
  * @since 1.0.0
  */
  public static function get_post_prefix_list($strict = false){
    if ( !XF::chksum_query('get','post_prefix') )
    XF::chksum_query('put','post_prefix',XF::hash_cache_keys(array('pp_id','pp_name','pp_preset_acl','pp_list_as_request'),false));
  $o = array();
  $rebuildcache = true;
  $cache = XFCache::get('simple','subject_prefix');
    if ( is_array($cache) ){
      foreach ( $cache as $k=>$v ){
        if ( XF::hash_cache_keys($v) === XF::chksum_query('get','post_prefix') )
        $o[$k] = $v;
      }
      if ( sizeof($cache) === sizeof($o) )
      $rebuildcache = false;
    }
  unset($cache);

    if ( $rebuildcache ){
    $spfx = XF::sql_query("SELECT * FROM ".XF::tbl('post_prefix'),'',__METHOD__,__LINE__);
      while ( $r = $spfx->fetchObject() ){
      $r->pp_id = intval($r->pp_id);
      $r->pp_name = $r->pp_name;
      $r->pp_list_as_request = (bool)$r->pp_list_as_request;
      $o[(int)$r->pp_id] = (array)$r;
      }
    $spfx->closeCursor();
      if ( XF::get_cfg('cache_main') )
      XFCache::put('simple','subject_prefix',$o);
    }
    if ( $strict ){
      foreach ( $o as $k=>$v ){
      $a = array('attr'=>array('acl'=>'','prefix'=>$k));
        if ( !self::topic_access($a,$o) )
        unset($o[$k]);
      }
    }
    foreach ( $o as $k=>$v )
    $o[$k]['pp_name'] = self::lang_str($v['pp_name']);

  return $o;
  }

  /**
  * check whether a new posting of this user is approved by default or not
  * @param integer $uid user id, current if not given
  * @param integer $gid group id, current if not given
  * @return boolean
  * @since 1.0.0
  */
  public static function get_post_approvement($uid = 0,$gid = 0){
  $du = XF::get_user($uid);
  $dg = XF::get_group($gid);
    if ( !$du || !$dg )
    return false;
  $o = ( $du['u_post_approved'] === 'default' ) ? $dg['g_post_approved'] : $du['u_post_approved'];
  return XF::sanitize_var($o,'bool');
  }

  /**
  * get posting weight list for html output
  * @param integer $gid group id, current if not given
  * @return array
  * @since 1.0.0
  */
  public static function get_post_weight_list($gid = 0){
  $o = array();
  $dg = XF::get_group($gid);
    if ( !$dg )
    return 1;
    for ( $i = 1 ; $i <= 5 ; $i++ )
    $o[$i] = ( $i <= $dg['g_max_post_weight'] ) ? '' : 'disabled="disabled"';
  return $o;
  }

}

/**
* this is a special function called by smarty engine inserting uncached content on runtime
* syntax: {insert name='xfi' class='[class_name]' [args as key-value-pair]}
*/
function insert_xfi($params,&$smarty){
static $cache_reported = null;
$class = ( isset($params['class']) ) ? preg_replace('/[^a-z0-9_]+/u','',strtolower($params['class'])) : '';

  switch ( $class ){
  case 'var': // fetch template variable prior set by XF::$tpl->assign()
  $a = ( isset($params['var']) ) ? XF::sanitize_var($params['var'],'str','restrict') : false;
  $b = ( isset($params['escape']) ) ? XF::sanitize_var($params['escape'],'int') : 1;
    if ( !isset(XF::$tpl->_tpl_vars[$a]) )
    return '{{VAR_MISS('.htmlspecialchars($a).')}}';
  $o = ( $b === 1 ) ? htmlspecialchars(XF::$tpl->_tpl_vars[$a]) : XF::$tpl->_tpl_vars[$a];
  return $o;
  break;
  case 'ajax_head': // initialization for asynchronous requests (for html head)
  return XFUI::$ajax_head;
  break;
  case 'tan': // transaction number to perform 'action'
  $id = ( isset($params['id']) ) ? XF::sanitize_var($params['id'],'action') : null;
  $html = ( isset($params['html']) ) ? XF::sanitize_var($params['html'],'booli') : 1;
    if ( is_null($id) || !isset($_SESSION['xf_tan'][$id]) )
    return ( $html === 1 ) ? '' : 0;
  return ( $html === 1 ) ? '<input type="hidden" name="tan" value="'.$_SESSION['xf_tan'][$id].'" />'.chr(10) : $_SESSION['xf_tan'][$id];
  break;
  case 'date': // format a timestamp
  $a = ( isset($params['ts']) ) ? XF::sanitize_var($params['ts'],'int') : 0;
  $b = ( isset($params['format']) ) ? XF::sanitize_var($params['format'],'str','okifempty,length=0-64') : '';
  $c = ( isset($params['readable']) ) ? XF::sanitize_var($params['readable'],'int','booli') : 0;
  $d = ( isset($params['now']) ) ? XF::sanitize_var($params['now'],'int','booli') : 0;
    if ( $d === 1 )
    $a = XF::vault_query('uts');
  return XF::date($a,$b,(bool)$c);
  break;
  case 'age': // calculate age of a timestamp
  $a = ( isset($params['ts']) ) ? XF::sanitize_var($params['ts'],'int') : 0;
  return XFParser::calculate_age($a);
  break;
  case 'i18n': // translate a string
  $n = ( isset($params['var']) ) ? XF::sanitize_var($params['var'],'str','restrict') : false;
  $l = ( isset($params['lang']) ) ? XF::sanitize_var($params['lang'],'lang') : false;
  $e = ( isset($params['erroronmiss']) ) ? XF::sanitize_var($params['erroronmiss'],'booli') : 1;
    if ( $n === false )
    return '';
  return XFUI::lang_str('{'.$l.':'.$n.'}',(bool)$e);
  break;
  case 'img': // get an image from imageset
  $n = ( isset($params['var']) ) ? XF::sanitize_var($params['var'],'str','restrict') : false;
  $r = ( isset($params['rate']) ) ? XF::sanitize_var($params['rate'],'int') : 0;
    if ( $n === false )
    return '';
    if ( $r !== 0 && $n === 'rating' )
    $n .= '_'.$r;
  return XFUI::image($n);
  break;
  case 'search_link': // link on search form to jump to previous results
  return (isset($_SESSION['xf_search_hash']))?'<div class="xf_form_item"><a href="'.XF::link('search',array('stage'=>'result','hash'=>$_SESSION['xf_search_hash'])).'" class="xf_button_link"><img src="'.XFUI::image('search_previous_result').'" alt="jump to previous search results" /> '.XFUI::i18n('jump_to_previous_results').'</a></div>':'';
  break;
  case 'post_link': // dynamic rendering of links on posting
  $mode = ( isset($params['mode']) ) ? XF::sanitize_var($params['mode'],'enum','o=bookmark,o=blacklist,o=report,o=edit,o=delete,o=cachemgr') : '';
  $id = ( isset($params['id']) ) ? XF::sanitize_var($params['id'],'int') : 0;
    switch ( $mode ){
    case 'bookmark':
      if ( isset($_SESSION['xf_bookmark']) && is_array($_SESSION['xf_bookmark']) ){
        if ( in_array($id,$_SESSION['xf_bookmark'],true) )
        return '<span id="xf_post_bookmark_'.$id.'" onclick="xajax_xf__handler(\'ucp_bookmark\',xf_var2arr(new Array(\'id\','.$id.',\'tan\','.$_SESSION['xf_tan']['ucp_bookmark'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('remove_bookmark').'</span>';
        else
        return '<span id="xf_post_bookmark_'.$id.'" onclick="xajax_xf__handler(\'ucp_bookmark\',xf_var2arr(new Array(\'id\','.$id.',\'tan\','.$_SESSION['xf_tan']['ucp_bookmark'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('add_bookmark').'</span>';
      }
    break;
    case 'blacklist':
      if ( isset($_SESSION['xf_blacklist']) && is_array($_SESSION['xf_blacklist']) ){
        if ( $id !== XF::vault_query('current_user_id') ){
          if ( in_array($id,$_SESSION['xf_blacklist'],true) )
          return '<span id="xf_post_blacklist_'.$id.'" onclick="xajax_xf__handler(\'ucp_blacklist\',xf_var2arr(new Array(\'id\','.$id.',\'tan\','.$_SESSION['xf_tan']['ucp_blacklist'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('remove_from_blacklist').'</span>';
          else
          return '<span id="xf_post_blacklist_'.$id.'" onclick="xajax_xf__handler(\'ucp_blacklist\',xf_var2arr(new Array(\'id\','.$id.',\'tan\','.$_SESSION['xf_tan']['ucp_blacklist'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('add_to_blacklist').'</span>';
        }
      }
    break;
    case 'report':
      if ( is_null($cache_reported) )
      $cache_reported = XFCache::get('simple','post_reported');
      if ( !is_array($cache_reported) )
      $cache_reported = array();
    return ( XF::access_control('ucp_request') && !in_array($id,$cache_reported,true) )
    ? '<span id="xf_post_report_'.$id.'" onclick="xajax_xf__handler(\'ucp_request\',xf_var2arr(new Array(\'data\','.$id.',\'stage\',\'report_posting\',\'tan\','.$_SESSION['xf_tan']['ucp_request'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('report_posting').'</span>'
    : '';
    break;
    case 'edit':
    return ( XF::access_control('post_edit') )
    ? '<span onclick="javascript:location.href=\''.XF::link('post_edit',array('post'=>$id)).'\';" class="xf_clickable xf_fake_link">'.XFUI::i18n('edit_post').'</span>'
    : '';
    break;
    case 'delete':
    return ( XF::access_control('post_delete') )
    ? '<span onclick="if(confirm(XFJSL_CONFIRM_ITEM))xajax_xf__handler(\'post_delete\',xf_var2arr(new Array(\'post\','.$id.',\'tan\','.$_SESSION['xf_tan']['post_delete'].')));" class="xf_clickable xf_fake_link">'.XFUI::i18n('delete_post').'</span>'
    : '';
    break;
    case 'cachemgr':
    return ( XF::access_control('cachemgr') )
    ? '<a href="'.XF::link('cachemgr',array('f_class'=>'post','f_postid'=>$id,'tan'=>$_SESSION['xf_tan']['cachemgr'])).'">'.XFUI::i18n('purge_post_cache').'</a>'
    : '';
    break;
    default: break;
    }
  return '';
  break;
  case 'post_is_new': // check whether a posting has not been marked as read yet
  $id = ( isset($params['id']) ) ? XF::sanitize_var($params['id'],'int') : 0;
  $ts = ( isset($params['ts']) ) ? XF::sanitize_var($params['ts'],'int') : 0;
  $mode = ( isset($params['mode']) ) ? XF::sanitize_var($params['mode'],'enum','o=search,o=topic,o=overview') : 'search';
  $new = XFParser::is_posting_read($id,$ts);
    if ( in_array($mode,array('overview','search'),true) && $new )
    return 'xf_search_result_posting_new';
    elseif ( $mode === 'topic' && $new )
    return 'xf_tl_posting_new';
  return '';
  break;
  case 'topic_status_bar': // status icons beside topic subject line
  $id = ( isset($params['id']) ) ? XF::sanitize_var($params['id'],'int') : 0;
  $cache = XFCache::topic($id);
    if ( !$cache )
    return false;
  $lastunread = XFParser::lastunread($cache);
  $o = '';
    if ( $cache['attr']['closed'] )
    $o .= '<img src="'.XFUI::image('post_closed').'" alt="closed topic" />'.chr(10);
    if ( in_array(XF::vault_query('current_user_id'),$cache['user']['trunk'],true) )
    $o .= '<img src="'.XFUI::image('post_user_involved').'" alt="user involved" />'.chr(10);
    if ( $lastunread )
    $o .= '<a href="'.XF::link('topic',array('post'=>$lastunread)).'#p'.$lastunread.'"><img src="'.XFUI::image('post_lastread').'" alt="jump to last unread post" /></a>'.chr(10);
  return $o;
  break;
  case 'link': // parse a link
    if ( sizeof($params) > 0 ){
    $a = '';
    $b = array();
    unset($params['name'],$params['class']);
      foreach ( $params as $k=>$v ){
        if ( $k === 'action' )
        $a = $v;
        else
        $b[$k] = $v;
      }
    return XF::link($a,$b);
    }
    else
    return '';
  break;
  case 'page_navigation': // parse page navigation
    if ( !function_exists('xflocal_link') ){
      function xflocal_link($a,$b){
        if ( $a === 'search' )
        return array('stage'=>'result','hash'=>(int)$b[0],'start'=>(int)$b[1],'pp'=>(int)$b[2]);
        elseif ( $a === 'topic' )
        return array('id'=>(int)$b[0],'start'=>(int)$b[1]);
      }
    }
  $pages = intval($params['pages']);
  $oset = intval($params['offset']);
  $perp = intval($params['perpage']);
  $curr = intval(ceil($oset/$perp)+1);
  $mod = $params['module'];
  $id = $params['id'];
  $pd = false;
    if ( !in_array($mod,array('search','topic'),true) )
    return ':illegal_module';
    if ( $curr > $pages || $oset < 0 )
    return ':illegal_offset';
    if ( $pages === 1 )
    return '';
    if ( $pages > XFUI::COMPACT_PAGEBAR_THRESHOLD ){
    $th = floor(XFUI::COMPACT_PAGEBAR_THRESHOLD/2);
    $pbmin = $curr-$th;
    $pbmax = $curr+$th;
    $pd = true;
    }
  //D(array('curr'=>$curr,'pbmin'=>$pbmin,'pbmax'=>$pbmax,'th'=>$th,'pages'=>$pages));
  $o = '<div class="xf_page_navigation">'.XFUI::i18n('page').':&nbsp;'.chr(10);
  $o .= ( $curr > 1 )
  ? '<a href="'.XF::link($mod,xflocal_link($mod,array($id,($curr-1)*$perp-$perp,$perp))).'" class="xf_pn_other">&lt;</a>'.chr(10)
  : '<span class="xf_pn_other">&lt;</span>'.chr(10);
    for ( $i = 1 ; $i <= $pages ; $i++ ){
    $no = intval($i*$perp-$perp);
      if ( $i === 1 && $pd && $i < $pbmin )
      $o .= '<a href="'.XF::link($mod,xflocal_link($mod,array($id,0,$perp))).'" class="xf_pn_other">'.$i.'</a>'.chr(10).'...'.chr(10);
      if ( $i === $pages && $pd && $pbmax < $pages )
      $o .= '...'.chr(10).'<a href="'.XF::link($mod,xflocal_link($mod,array($id,$no,$perp))).'" class="xf_pn_other">'.$pages.'</a>'.chr(10);
      if ( $pd && ( $i < $pbmin || $i > $pbmax ) )
      continue;
    $o .= ( $i === $curr )
    ? '<span class="xf_pn_current">'.$i.'</span>'.chr(10)
    : '<a href="'.XF::link($mod,xflocal_link($mod,array($id,$no,$perp))).'" class="xf_pn_other">'.$i.'</a>'.chr(10);
    }
  $o .= ( $curr !== $pages )
  ? '<a href="'.XF::link($mod,xflocal_link($mod,array($id,$curr*$perp,$perp))).'" class="xf_pn_other">&gt;</a>'.chr(10)
  : '<span class="xf_pn_other">&gt;</span>'.chr(10);
  $o .= '</div>';
  return $o;
  break;
  default: break;
  }
return '(('.__METHOD__.' ** CLASS '.$class.' UNDEFINED **))';
}
?>