/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 15-feb-2005 by Alessio Tregia
 * Copyright  2005 Alessio Treglia
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.io.IOException;

/**
 * Incapsula un interprete di comandi per il gioco jRisk.
 * Fornisce anche delle operazioni di lettura da tastiera
 * per ogni singolo Giocatore.
 * 
 * @author Alessio Treglia
 * @version 1.0.1
 */
public class Parser {
    /** Elenco dei comandi validi */
    private ElencoComandi comandi;
    
    /**
     * Inizializza l'oggetto Parser
     */
    public Parser() {
        comandi = new ElencoComandi();
    }
    /**
     * Legge un int dalla tastiera
     * 
     * @return <code>int</code> letto dalla tastiera
     * @throws <code>IOException</code>
     */
    public int getInt() throws IOException {
        //int n = System.in.read();
        int n = Lettore.in.leggiInt();
        //return Character.getNumericValue(n);
        return n;
    }
    /**
     * Legge una parola immessa dalla tastiera.
     * 
     * @return la parola letta dalla tastiera
     * @throws <code>IOException</code>
     */
    public String getParola() throws IOException {
        /*String inputLine = "";
        String parola;
        BufferedReader reader;
        StringTokenizer tokenizer;
        
        System.out.print(" ");
        
        reader = new BufferedReader(new InputStreamReader(System.in));
        
        try {
            inputLine = reader.readLine();
        }
        catch(IOException e) {
            System.out.println("Errore nella lettura: " + e.getMessage());
        }
        tokenizer = new StringTokenizer(inputLine);
        
        if(tokenizer.hasMoreTokens())
            parola = tokenizer.nextToken();		// parola
        else
            parola = null;
        
        return parola;*/
        
        String parola;
        parola = Lettore.in.leggiString();
        
        return parola;
        
    }
    
    /**
     * Legge dalla tastiera una comando pi gli eventuali
     * argomenti. Se lo riconosce come valido allora crea
     * un oggetto Comando per eseguire l'azione richiesta
     * dall'utente.
     * 
     * @return un oggetto <code>Comando</code> contenente
     * un'azione da eseguire richiesta dall'utente
     */
    public Comando getComando() {
        String inputLine = "";
        String primaParola;
        String secondaParola;
        String terzaParola;
        String quartaParola;

        System.out.print("> ");

        BufferedReader reader =
            new BufferedReader(new InputStreamReader(System.in));
        try {
            inputLine = reader.readLine();
        }
        catch(java.io.IOException exc) {
            System.out.println ("Errore durante la lettura: "
                                + exc.getMessage());
        }

        StringTokenizer tokenizer = new StringTokenizer(inputLine);

        if(tokenizer.hasMoreTokens())
            primaParola = tokenizer.nextToken();		// prima parola
        else
            primaParola = null;
        if(tokenizer.hasMoreTokens())
            secondaParola = tokenizer.nextToken();    	// seconda parola
        else
            secondaParola = null;
        if(tokenizer.hasMoreTokens())
            terzaParola = tokenizer.nextToken();      	// terza parola
        else
            terzaParola = null;
        if(tokenizer.hasMoreTokens())
            quartaParola = tokenizer.nextToken();      	// quarta parola
        else
            quartaParola = null;

        // nota: ignoriamo il resto della linea

        // Se primaParola e' un comando creo un oggetto comando. altrimenti creo un
        // comando null

        if(comandi.comandoValido(primaParola)) {            
            if (primaParola.equals("attacca"))
                    return new ComandoAttacca(secondaParola,terzaParola);
            if (primaParola.equals("sposta"))
                    return new ComandoSposta(secondaParola,terzaParola);
            if (primaParola.equals("passa"))
                	return new ComandoPassaTurno();
            if(primaParola.equals("stampa"))
                	return new ComandoStampa(secondaParola);
/*            if(primaParola.equals("giocacarte"))
                    return new ComandoGiocaCarte();*/
            if(primaParola.equals("aiuto"))
                	return new ComandoAiuto(secondaParola);
            if(primaParola.equals("versione"))
                	return new ComandoVersione();
            if (primaParola.equals("esci"))
                    return new ComandoEsci();                   
       }
       return new ComandoNonValido();
    }
}
