/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 17-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */

import java.util.List;
import java.util.Iterator;

/**
 * <p>Contiene l'elenco delle carte del gioco. Verifica che il
 * nome di una carta sia valido, restituisce l'elenco delle
 * carte del gioco e stabilisce se un mazzo di carte sia
 * combinato.</p>
 * 
 * @author Alessio Treglia
 * @version 1.0.0
 */
public class ElencoCarte {
    /** Elenco delle carte del gioco */
    public static final String CARTE[] = {
            "cannone",
            "fante",
            "cavallo",
            "jolly",
    };
    /** Numero di armate per un tris di cannoni */
    private static final int TRISCANNONI = 4;
    /** Numero di armate per un tris di fanti */
    private static final int TRISFANTI = 6;
    /** Numero di armate per un tris di cavalli */
    private static final int TRISCAVALLI = 8;
    /** Numero di armate per tre carte diverse */
    private static final int COMBO = 10;
    /** Numero di armate per un tris col jolly */
    private static final int TRISJOLLY = 12;
    
    /**
     * Controlla che una stringa sia un nome valido per
     * una carta.
     * 
     * @param carta nome <code>String</code>della carta
     * @return <code>true</code> se il nome  un nome valido per
     * una carta
     */
    public static boolean cartaValida(String carta) {
        for(int i=0; i<CARTE.length; i++)
            if(carta.equals(CARTE[i]))
                return true;
        return false;
    }
    
    /**
     * Restituisce in una stringa l'elenco delle carte
     * 
     * @return una <code>String</code> contenente l'elenco
     * delle carte
     */
    public static String elencoTutteCarte() {
    	int i=0;
    	StringBuffer elenco = new StringBuffer();

    	for (i=0; i<CARTE.length-1; i++) {
			elenco.append(CARTE[i]);
			elenco. append(", ");
		}
		elenco.append(CARTE[i]);
		return elenco.toString();
    }
    /**
     * <p>Restituisce il risultato della verifica sulle
     * combinazioni. Le possibili combinazioni sono:</p>
     * <pre>
     * - 3 cannoni
     * - 3 fanti
     * - 3 cavalli
     * - 1 cannone + 1 fante + 1 cavallo
     * - 2 carte uguali + 1 jolly
     * </pre>
     * @param carte <code>List</code> di carte
     * @return <code>true</code> se almeno una delle
     * combinazioni di sopra  presente fra le carte
     */
    public static boolean combinazioneValida(List carte) {
        Iterator it = carte.iterator();
        String temp;
        int cannoni = 0;
        int fanti = 0;
        int cavalli = 0;
        int jolly = 0;
        /* Conto il numero di carte per ogni tipo di valore */
        while(it.hasNext()) {
            temp = (String) it.next();
            if(temp.equals("cannone"))
                cannoni++;
            if(temp.equals("fante"))
                fanti++;
            if(temp.equals("cavallo"))
                cavalli++;
            else
                jolly++;
        }
        /* Verifico la presenza di combinazioni */
        if(
                (cannoni >= 3 || fanti >= 3 || cavalli >= 3) ||		// Tris
                (cannoni >= 1 && fanti >= 1 && cavalli >= 1) ||		// Tre carte diverse
                ( (cannoni > 1 || fanti > 1 || cavalli > 1) && jolly >= 1) // Tris con il jolly
                )
            return true;
        
        return false;
    }
    /**
     * Restituisce il numero di armate che si ricevono se si hanno 3 cannoni
     * 
     * @return numero di armate spettanti al giocatore
     */
    public static int armateTrisCannoni() { return TRISCANNONI; }
    /**
     * Restituisce il numero di armate che si ricevono se si hanno 3 fanti
     * 
     * @return numero di armate spettanti al giocatore
     */
    public static int armateTrisFanti() { return TRISFANTI; }
    /**
     * Restituisce il numero di armate che si ricevono se si hanno 3 cavalli
     * 
     * @return numero di armate spettanti al giocatore
     */
    public static int armateTrisCavalli() { return TRISCAVALLI; }
    /**
     * Restituisce il numero di armate che si ricevono se si ha
     * una combinazione con tre carte diverse
     * 
     * @return numero di armate spettanti al giocatore
     */
    public static int armateCombo() { return COMBO; }
    /**
     * Restituisce il numero di armate che si ricevono se si hanno
     * 2 carte di un tipo + 1 jolly
     * 
     * @return numero di armate spettanti al giocatore
     */
    public static int armateTrisJolly() { return TRISJOLLY; }
    
}
