/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DistributoreArmate {
    private static final int ARMATE_OGNI_TERRITORI = 3;
    private static final int ARMATE_NORDAMERICA = 5;
    private static final int ARMATE_SUDAMERICA = 2;
    private static final int ARMATE_EUROPA = 5;
    private static final int ARMATE_AFRICA = 3;
    private static final int ARMATE_ASIA = 7;
    private static final int ARMATE_OCEANIA = 2;

    private static int calcolaArmatePerContinente(Giocatore giocatore) {
        Set territori = giocatore.getTerritori();
        Iterator it = territori.iterator();
        int armate = 0;
        int nordAmerica = 0;
        int sudAmerica = 0;
        int europa = 0;
        int africa = 0;
        int asia = 0;
        int oceania = 0;
        while (it.hasNext()) {
            Territorio temp = (Territorio)it.next();
            if (temp.getContinente().equals("nordamerica")) {
                ++nordAmerica;
            }
            if (temp.getContinente().equals("sudamerica")) {
                ++sudAmerica;
            }
            if (temp.getContinente().equals("europa")) {
                ++europa;
            }
            if (temp.getContinente().equals("africa")) {
                ++africa;
            }
            if (temp.getContinente().equals("asia")) {
                ++asia;
            }
            if (!temp.getContinente().equals("oceania")) continue;
            ++oceania;
        }
        if (nordAmerica == ElencoTerritoriContinenti.numeroTerritoriNordAmerica()) {
            armate += 5;
        }
        if (sudAmerica == ElencoTerritoriContinenti.numeroTerritoriSudAmerica()) {
            armate += 2;
        }
        if (europa == ElencoTerritoriContinenti.numeroTerritoriEuropa()) {
            armate += 5;
        }
        if (asia == ElencoTerritoriContinenti.numeroTerritoriAsia()) {
            armate += 7;
        }
        if (africa == ElencoTerritoriContinenti.numeroTerritoriAfrica()) {
            armate += 3;
        }
        if (oceania == ElencoTerritoriContinenti.numeroTerritoriOceania()) {
            armate += 2;
        }
        return armate;
    }

    private static boolean trisCannoni(List carte) {
        return Collections.frequency(carte, "cannone") > 2;
    }

    private static boolean trisFanti(List carte) {
        return Collections.frequency(carte, "fante") > 2;
    }

    private static boolean trisCavalli(List carte) {
        return Collections.frequency(carte, "cavallo") > 2;
    }

    private static boolean comboCarte(List carte) {
        return carte.contains("cannone") && carte.contains("fante") && carte.contains("cavallo");
    }

    private static String trisJolly(List carte) {
        if (carte.contains("jolly")) {
            if (Collections.frequency(carte, "cannone") > 1) {
                return "cannone";
            }
            if (Collections.frequency(carte, "fante") > 1) {
                return "fante";
            }
            if (Collections.frequency(carte, "cavallo") > 1) {
                return "cavallo";
            }
        }
        return null;
    }

    public static int calcolaArmatePerCarte(Giocatore g) {
        int armate = 0;
        List carte = g.getCarte();
        boolean comboFinite = false;
        while (carte.size() > 2 && !comboFinite) {
            if (DistributoreArmate.trisJolly(carte) != null) {
                armate += ElencoCarte.armateTrisJolly();
                g.rimuoviCarteStessoValore(DistributoreArmate.trisJolly(carte), 2);
                g.rimuoviCarta("jolly");
            } else if (DistributoreArmate.comboCarte(carte)) {
                armate += ElencoCarte.armateCombo();
                g.rimuoviCarta("cavallo");
                g.rimuoviCarta("fante");
                g.rimuoviCarta("cannone");
            } else if (DistributoreArmate.trisCavalli(carte)) {
                armate += ElencoCarte.armateTrisCavalli();
                g.rimuoviCarteStessoValore("cavallo", 3);
            } else if (DistributoreArmate.trisFanti(carte)) {
                armate += ElencoCarte.armateTrisFanti();
                g.rimuoviCarteStessoValore("fante", 3);
            } else if (DistributoreArmate.trisCannoni(carte)) {
                armate += ElencoCarte.armateTrisCannoni();
                g.rimuoviCarteStessoValore("cannone", 3);
            } else {
                comboFinite = true;
            }
            carte = g.getCarte();
        }
        return armate;
    }

    public static int daiArmate(Giocatore giocatore) {
        return giocatore.getTerritori().size() / 3 + DistributoreArmate.calcolaArmatePerContinente(giocatore) + DistributoreArmate.calcolaArmatePerCarte(giocatore);
    }
}

