/*
 * Decompiled with CFR 0.152.
 */
package hr.fjagic.jdosage2.webcomic;

import hr.fjagic.jdosage2.Configuration;
import hr.fjagic.jdosage2.webcomic.ValidationException;
import hr.fjagic.jdosage2.webcomic.Webcomic;
import hr.fjagic.jdosage2.webcomic.WebcomicException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScraperWebcomic
extends Webcomic {
    private static final long serialVersionUID = -4488900918904518616L;
    private static final String FIRST_PAGE = "firstPage";
    private static final String LAST_PAGE = "lastPage";
    private static final String COMIC = "comic";
    private static final String NEXT_PAGE = "nextPage";
    private static final String PROGRESS_PAGE = "page";
    private static final String METADATA_PAGE_URL = "pageUrl";
    private static final String METADATA_PAGE_TITLE = "pageTitle";
    private static final String METADATA_IMAGE_TEXT = "imageText";

    public String getFirstPage() {
        return StringUtils.trimToNull((String)this.getProperty(FIRST_PAGE));
    }

    public String getLastPage() {
        return StringUtils.trimToNull((String)this.getProperty(LAST_PAGE));
    }

    public String getComic() {
        return StringUtils.trimToNull((String)this.getProperty(COMIC));
    }

    public String getNextPage() {
        return StringUtils.trimToNull((String)this.getProperty(NEXT_PAGE));
    }

    private String getCurrentPage() {
        return StringUtils.trimToNull((String)this.getProgress().get(PROGRESS_PAGE));
    }

    private void setCurrentPage(String currentPage) {
        this.getProgress().put(PROGRESS_PAGE, currentPage);
    }

    @Override
    public void validate() throws ValidationException {
        super.validate();
        if (this.getFirstPage() == null && this.getLastPage() == null) {
            throw new ValidationException(LAST_PAGE, "lastPage is required");
        }
        if (this.getLastPage() != null) {
            try {
                new URL(this.getLastPage());
            }
            catch (MalformedURLException e) {
                throw new ValidationException(LAST_PAGE, e);
            }
        }
        try {
            new URL(this.getFirstPage());
        }
        catch (MalformedURLException e) {
            throw new ValidationException(FIRST_PAGE, e);
        }
        if (this.getComic() == null) {
            throw new ValidationException(COMIC, "comic is required");
        }
        try {
            new Document("").select(this.getComic());
        }
        catch (Exception e) {
            throw new ValidationException(COMIC, e);
        }
        if (this.getNextPage() == null) {
            throw new ValidationException(NEXT_PAGE, "nextPage is required");
        }
        try {
            new Document("").select(this.getNextPage());
        }
        catch (Exception e) {
            throw new ValidationException(NEXT_PAGE, e);
        }
        if (this.getCurrentPage() != null) {
            try {
                new URL(this.getCurrentPage());
            }
            catch (MalformedURLException e) {
                throw new ValidationException(PROGRESS_PAGE, "Progress data is invalid", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean downloadNext(Configuration config) throws IOException, WebcomicException {
        String pageUrl = (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCurrentPage(), this.getLastPage(), this.getFirstPage()});
        this.logger.debug("Downloading next {} from {}", (Object)this.getName(), (Object)pageUrl);
        try {
            String nextUrl;
            block21: {
                Elements nextPages;
                block20: {
                    String imageUrl;
                    Elements comics;
                    Elements titles;
                    this.validate();
                    HashMap<String, String> metadata = new HashMap<String, String>();
                    metadata.put(METADATA_PAGE_URL, this.decodeUrl(pageUrl));
                    Document document = this.downloadWebpage(pageUrl, config);
                    Elements baseTags = document.select("base[href]");
                    if (!baseTags.isEmpty()) {
                        document.setBaseUri(baseTags.first().absUrl("href"));
                    }
                    if (!(titles = document.select("head title")).isEmpty()) {
                        Element title = titles.first();
                        this.logger.trace("Found title: {}", (Object)title);
                        metadata.put(METADATA_PAGE_TITLE, this.decodeHtml(title.ownText()));
                    }
                    if ((comics = document.select(this.getComic())).isEmpty()) {
                        if (!config.isIgnoreMissingComics()) {
                            throw new WebcomicException("No " + this.getName() + " comics found in " + pageUrl);
                        }
                        this.logger.warn("No {} comics found in {}", (Object)this.getName(), (Object)pageUrl);
                    }
                    Iterator iterator = comics.iterator();
                    do {
                        String imageText;
                        if (!iterator.hasNext()) {
                            nextPages = document.select(this.getNextPage());
                            if (nextPages.isEmpty()) {
                                this.logger.trace("Link to next page not found, stopping");
                                if (this.isResetWhenFinished()) {
                                    this.getProgress().clear();
                                }
                                return false;
                            }
                            break block20;
                        }
                        Element comic = (Element)iterator.next();
                        this.logger.trace("Found comic: {}", (Object)comic);
                        if ("img".equalsIgnoreCase(comic.tagName())) {
                            imageUrl = comic.absUrl("src");
                            imageText = comic.attr("alt");
                        } else {
                            if (!"a".equalsIgnoreCase(comic.tagName())) {
                                throw new WebcomicException("Comic " + comic + " is not an image or a link");
                            }
                            imageUrl = comic.absUrl("href");
                            imageText = comic.ownText();
                        }
                        metadata.put(METADATA_IMAGE_TEXT, this.decodeHtml(imageText));
                    } while (this.downloadComic(metadata, imageUrl, pageUrl, config) || !this.isResetWhenFinished() || config.isIgnoreExistingComics());
                    this.logger.trace("Comic file exists, stopping");
                    this.getProgress().clear();
                    return false;
                }
                nextUrl = null;
                Iterator iterator = nextPages.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (nextUrl.equals(pageUrl)) {
                            this.logger.warn("{} next page url {} is same as the current page", (Object)this.getName(), (Object)nextUrl);
                            return false;
                        }
                        break block21;
                    }
                    Element nextPage = (Element)iterator.next();
                    if (!"a".equalsIgnoreCase(nextPage.tagName())) {
                        throw new WebcomicException("Next page " + nextPage + " is not a link");
                    }
                    this.logger.trace("Found next page link: {}", (Object)nextPage);
                    String newUrl = nextPage.absUrl("href");
                    if (nextUrl == null) {
                        nextUrl = newUrl;
                        continue;
                    }
                    if (!nextUrl.equals(newUrl)) break;
                }
                throw new WebcomicException("More than one next page link found: " + nextPages);
            }
            this.setCurrentPage(nextUrl.toString());
            return true;
        }
        catch (IOException e) {
            throw e;
        }
        catch (WebcomicException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebcomicException("Error downloading " + this.getName() + " from " + this.getCurrentPage(), e);
        }
    }

    @Override
    protected boolean isResetWhenFinished() {
        return this.getLastPage() != null;
    }
}

