/*
 * Decompiled with CFR 0.152.
 */
package hr.fjagic.jdosage2;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
extends Properties {
    private static final long serialVersionUID = -5532872512283240474L;
    private static Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static Configuration instance;
    private static final File BASE_DIR;
    private static final File CONFIGURATION_FILE;
    private static final File PROGRESS_FILE;
    private static final File DEFINITIONS_DIR;
    private static final String SCRAPERWEBCOMIC_EXTENSION = "wcd";
    private static final String USER_AGENT = "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:16.0) Gecko/20100101 Firefox/16.0";
    private static final String DOWNLOAD_DIR = "download.dir";
    private static final String CONNECTION_TIMEOUT = "connection.timeout";
    private static final String CONNECTION_RETRIES = "connection.retries";
    private static final String LOG_LEVEL_CONSOLE = "log.level.console";
    private static final String LOG_LEVEL_FILE = "log.level.file";
    private boolean ignoreExistingComics = false;
    private boolean ignoreMissingComics = false;

    static {
        BASE_DIR = new File(System.getProperty("user.home"), ".jdosage2");
        CONFIGURATION_FILE = new File(BASE_DIR, "config.properties");
        PROGRESS_FILE = new File(BASE_DIR, "progress.properties");
        DEFINITIONS_DIR = new File(BASE_DIR, "webcomics");
    }

    private Configuration() {
        super(Configuration.getDefaults());
        if (CONFIGURATION_FILE.exists()) {
            try {
                FileReader reader = new FileReader(CONFIGURATION_FILE);
                this.load(reader);
                IOUtils.closeQuietly(reader);
            }
            catch (IOException e) {
                logger.error("Error reading configuration file", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Error loading configuration", (Throwable)e);
            }
        } else {
            try {
                BASE_DIR.mkdirs();
                this.defaults.store(new FileWriter(CONFIGURATION_FILE), "JDosage2 configuration");
                DEFINITIONS_DIR.mkdirs();
                logger.trace("Default configuration file {} created", (Object)CONFIGURATION_FILE);
            }
            catch (IOException e) {
                logger.error("Error creating default configuration", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Error saving configuration", (Throwable)e);
            }
        }
    }

    private static Properties getDefaults() {
        Properties defaults = new Properties();
        File downloadDir = new File(System.getProperty("user.home"), "Webcomics");
        defaults.setProperty(DOWNLOAD_DIR, downloadDir.getPath());
        defaults.setProperty(CONNECTION_TIMEOUT, "10");
        defaults.setProperty(CONNECTION_RETRIES, "3");
        defaults.setProperty(LOG_LEVEL_CONSOLE, Level.INFO.toString());
        defaults.setProperty(LOG_LEVEL_FILE, Level.DEBUG.toString());
        return defaults;
    }

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public File getProgressFile() {
        return PROGRESS_FILE;
    }

    public File getDefinitionsDir() {
        return DEFINITIONS_DIR;
    }

    public String getDefinitionExt() {
        return SCRAPERWEBCOMIC_EXTENSION;
    }

    public String getUserAgent() {
        return USER_AGENT;
    }

    public File getDownloadDir() {
        return new File(this.getProperty(DOWNLOAD_DIR));
    }

    public int getConnectionTimeout() {
        return NumberUtils.toInt((String)this.getProperty(CONNECTION_TIMEOUT), (int)10);
    }

    public int getConnectionRetries() {
        return NumberUtils.toInt((String)this.getProperty(CONNECTION_RETRIES), (int)3);
    }

    public boolean isIgnoreExistingComics() {
        return this.ignoreExistingComics;
    }

    public void setIgnoreExistingComics(boolean ignoreExistingComics) {
        this.ignoreExistingComics = ignoreExistingComics;
    }

    public boolean isIgnoreMissingComics() {
        return this.ignoreMissingComics;
    }

    public void setIgnoreMissingComics(boolean ignoreMissingComics) {
        this.ignoreMissingComics = ignoreMissingComics;
    }
}

