/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PropertiesFile
extends Properties {
    File file;
    String header = "netx file";
    boolean loaded = false;

    public PropertiesFile(File file) {
        this.file = file;
    }

    public PropertiesFile(File file, String header) {
        this.file = file;
        this.header = header;
    }

    @Override
    public String getProperty(String key) {
        if (!this.loaded) {
            this.load();
        }
        return super.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (!this.loaded) {
            this.load();
        }
        return super.getProperty(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        if (!this.loaded) {
            this.load();
        }
        return super.setProperty(key, value);
    }

    public File getStoreFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.loaded = true;
        FileInputStream s = null;
        try {
            if (!this.file.exists()) {
                return;
            }
            try {
                s = new FileInputStream(this.file);
                this.load(s);
            }
            finally {
                if (s != null) {
                    ((InputStream)s).close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        if (!this.loaded) {
            return;
        }
        FileOutputStream s = null;
        try {
            try {
                s = new FileOutputStream(this.file);
                this.store(s, this.header);
            }
            finally {
                if (s != null) {
                    ((OutputStream)s).close();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

