/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.ComboItem;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;

public class DebuggingPanel
extends NamedBorderPanel
implements ItemListener {
    public static String[] properties = new String[]{"deployment.trace", "deployment.log", "deployment.console.startup.mode"};
    private DeploymentConfiguration config;

    public DebuggingPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadDebugging"), new GridBagLayout());
        this.config = config;
        this.addComponents();
    }

    private void addComponents() {
        GridBagConstraints c = new GridBagConstraints();
        JLabel debuggingDescription = new JLabel("<html>" + Translator.R("CPDebuggingDescription") + "<hr /><br /></html>");
        JCheckBox[] debuggingOptions = new JCheckBox[]{new JCheckBox(Translator.R("DPEnableTracing")), new JCheckBox(Translator.R("DPEnableLogging"))};
        ComboItem[] javaConsoleItems = new ComboItem[]{new ComboItem(Translator.R("DPDisable"), "DISABLE"), new ComboItem(Translator.R("DPHide"), "HIDE"), new ComboItem(Translator.R("DPShow"), "SHOW")};
        JLabel consoleLabel = new JLabel(Translator.R("DPJavaConsole"));
        JComboBox<ComboItem> consoleComboBox = new JComboBox<ComboItem>();
        consoleComboBox.setActionCommand("deployment.console.startup.mode");
        JPanel consolePanel = new JPanel();
        consolePanel.setLayout(new FlowLayout(3));
        consolePanel.add(consoleLabel);
        consolePanel.add(consoleComboBox);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)debuggingDescription, c);
        for (int i = 0; i < properties.length; ++i) {
            try {
                String s = this.config.getProperty(properties[i]);
                c.gridy = i + 1;
                switch (i) {
                    case 0: 
                    case 1: {
                        debuggingOptions[i].setSelected(Boolean.parseBoolean(s));
                        debuggingOptions[i].setActionCommand(properties[i]);
                        debuggingOptions[i].addItemListener(this);
                        this.add((Component)debuggingOptions[i], c);
                        break;
                    }
                    case 2: {
                        for (int j = 0; j < javaConsoleItems.length; ++j) {
                            consoleComboBox.addItem(javaConsoleItems[j]);
                            if (!this.config.getProperty("deployment.console.startup.mode").equals(javaConsoleItems[j].getValue())) continue;
                            consoleComboBox.setSelectedIndex(j);
                        }
                        consoleComboBox.addItemListener(this);
                        this.add((Component)consolePanel, c);
                    }
                }
                continue;
            }
            catch (Exception e) {
                debuggingOptions[i] = null;
            }
        }
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridy;
        c.weighty = 1.0;
        this.add(filler, c);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object o = e.getSource();
        if (o instanceof JCheckBox) {
            JCheckBox jcb = (JCheckBox)o;
            this.config.setProperty(jcb.getActionCommand(), String.valueOf(jcb.isSelected()));
        } else if (o instanceof JComboBox) {
            JComboBox jcb = (JComboBox)o;
            ComboItem c = (ComboItem)e.getItem();
            this.config.setProperty(jcb.getActionCommand(), c.getValue());
        }
    }
}

