/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.util;

import java.awt.EventQueue;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;

public class ModalDialogHandler {
    private static final Logger LOGGER = Logger.getLogger(ModalDialogHandler.class.getName());
    private final JDialog dialog;
    private boolean showDialog;
    private boolean closeDialog;
    private boolean isShowing;
    private Condition dialogIsShowing;
    private Lock showingLock;

    public ModalDialogHandler(JDialog dialog) {
        this.dialog = dialog;
        this.showDialog = true;
        this.closeDialog = false;
        this.showingLock = new ReentrantLock();
        this.dialogIsShowing = this.showingLock.newCondition();
    }

    public synchronized void show() {
        if (this.showDialog) {
            this.dialog.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent e) {
                    if (e.getID() == 102) {
                        ModalDialogHandler.this.dialogShown();
                    }
                }
            });
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ModalDialogHandler.this.dialog.setVisible(true);
                }
            });
            this.closeDialog = true;
            LOGGER.fine("dialog set visible");
        }
    }

    public synchronized void hide() {
        this.showDialog = false;
        if (this.closeDialog) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    LOGGER.fine("waiting for dialog to become visible");
                    ModalDialogHandler.this.showingLock.lock();
                    try {
                        while (!ModalDialogHandler.this.isShowing) {
                            ModalDialogHandler.this.dialogIsShowing.await();
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    finally {
                        ModalDialogHandler.this.showingLock.unlock();
                    }
                    LOGGER.fine("dialog became visible");
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            ModalDialogHandler.this.dialog.setVisible(false);
                        }
                    });
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dialogShown() {
        try {
            this.showingLock.lock();
            this.isShowing = true;
            LOGGER.fine("dialog is showing");
            this.dialogIsShowing.signalAll();
        }
        finally {
            this.showingLock.unlock();
        }
    }
}

