/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.util;

import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.WinRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class AutoStarter {
    private static final Logger LOGGER = Logger.getLogger(AutoStarter.class.getName());
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String WINDOWS_RUN_TREE = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run";
    private static final File KDE_AUTOSTART_DIR = new File(USER_HOME + "/.kde/Autostart");
    private static final File FREE_DESKTOP_AUTOSTART_DIR = new File(USER_HOME + "/.config/autostart");
    private static final File OSX_LAUNCH_AGENTS_DIR = new File(USER_HOME, "Library/LaunchAgents");
    private final File osxScriptDir;
    private final File osxLaunchAgentsFile;
    private final URL codeBase;
    private final String startCommand;
    private final boolean isIDE_Start;

    public AutoStarter(String jnlpFileName, String osxDockName, String osxScriptsDirName, String osxLaunchAgentsFileName, String options) {
        this.osxScriptDir = new File(USER_HOME, "Library/Scripts/Applications/" + osxScriptsDirName);
        this.osxLaunchAgentsFile = new File(OSX_LAUNCH_AGENTS_DIR, osxLaunchAgentsFileName + ".plist");
        BasicService basicService = null;
        try {
            basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException ex) {
            LOGGER.log(Level.FINE, "not starting via Java Web Start", ex);
        }
        if (basicService == null) {
            this.codeBase = null;
            String pathToJAR = this.getPathToJAR();
            this.isIDE_Start = pathToJAR.contains(PATH_SEPARATOR);
            switch (CurrentOperatingSystem.OS) {
                default: {
                    this.startCommand = "java -jar \"" + pathToJAR + "\"" + (options == null ? "" : ' ' + options);
                    break;
                }
                case Mac_OS_X: {
                    int appIndex = pathToJAR.indexOf(".app/Contents/Resources/Java/");
                    if (appIndex == -1) {
                        this.startCommand = "java -Xdock:name=" + osxDockName + " -jar \"" + pathToJAR + "\"" + (options == null ? "" : ' ' + options);
                        break;
                    }
                    String stubPath = pathToJAR.substring(0, appIndex) + ".app/Contents/MacOS/JavaApplicationStub";
                    this.startCommand = "exec \"" + stubPath + '\"' + (options == null ? "" : ' ' + options);
                    break;
                }
                case Windows: {
                    this.startCommand = "\"javaw -jar \\\"" + pathToJAR.replaceAll("\\\\", "\\\\\\\\") + "\\\"" + (options == null ? "" : ' ' + options) + '\"';
                    break;
                }
            }
        } else {
            this.codeBase = basicService.getCodeBase();
            this.isIDE_Start = false;
            this.startCommand = "javaws" + (options == null ? "" : " -open " + options) + ' ' + this.codeBase + jnlpFileName + ".jnlp";
        }
        LOGGER.log(Level.FINEST, "startCommand: {0}", this.startCommand);
    }

    public boolean isWebStart() {
        return this.codeBase != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void checkWebStartConfig(String windowsRunTreeKey, String linuxIconSource, String linuxIconFileName, String linuxDesktopFileTemplate, String linuxDesktopFileName) {
        String lcCodebase = this.codeBase.toString().toLowerCase();
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                BufferedReader reader = null;
                File linuxDesktopFile = new File(FREE_DESKTOP_AUTOSTART_DIR, linuxDesktopFileName + ".desktop");
                reader = new BufferedReader(new FileReader(linuxDesktopFile));
                String line = reader.readLine();
                while (line != null) {
                    String[] tokens;
                    if (!(!line.startsWith("Exec=") || (tokens = line.split(" ")).length == 2 && tokens[0].equals("javaws") && tokens[1].toLowerCase().startsWith(lcCodebase))) {
                        this.enableLinuxAutostart(linuxIconSource, linuxIconFileName, linuxDesktopFileTemplate, linuxDesktopFileName);
                    }
                    line = reader.readLine();
                }
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                break;
                catch (IOException ex) {
                    try {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex2) {
                            LOGGER.log(Level.WARNING, null, ex2);
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException ex3) {
                        LOGGER.log(Level.WARNING, null, ex3);
                    }
                    break;
                }
            }
            case Windows: {
                WinRegistry winRegistry = new WinRegistry();
                String autoStartPath = winRegistry.getValue(WINDOWS_RUN_TREE, "\"" + windowsRunTreeKey + "\"");
                String[] tokens = autoStartPath.split(" ");
                if (tokens.length == 2 && tokens[1].toLowerCase().startsWith(lcCodebase)) break;
                this.enableWindowsAutoStart(windowsRunTreeKey);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported!", (Object)CurrentOperatingSystem.OS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getCurrentAutoStartPath(String linuxDesktopFileName, String windowsRunTreeKey) {
        String autoStartPath = null;
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                BufferedReader reader = null;
                File linuxDesktopFile = new File(FREE_DESKTOP_AUTOSTART_DIR, linuxDesktopFileName + ".desktop");
                reader = new BufferedReader(new FileReader(linuxDesktopFile));
                String line = reader.readLine();
                while (line != null) {
                    int jarIndex;
                    if (line.startsWith("Exec=") && (jarIndex = line.indexOf(" -jar ")) != -1) {
                        autoStartPath = line.substring(jarIndex + 6);
                        break;
                    }
                    line = reader.readLine();
                }
                try {
                    if (reader == null) break;
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                break;
                catch (IOException ex) {
                    try {
                        LOGGER.log(Level.WARNING, null, ex);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException ex2) {
                            LOGGER.log(Level.WARNING, null, ex2);
                        }
                        throw throwable;
                    }
                    try {
                        if (reader == null) break;
                        reader.close();
                    }
                    catch (IOException ex3) {
                        LOGGER.log(Level.WARNING, null, ex3);
                    }
                    break;
                }
            }
            case Windows: {
                WinRegistry winRegistry = new WinRegistry();
                autoStartPath = winRegistry.getValue(WINDOWS_RUN_TREE, "\"" + windowsRunTreeKey + "\"");
                if (autoStartPath == null) break;
                autoStartPath = autoStartPath.replaceAll("\\\\\\\\", "\\\\");
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "{0} is not supported!", (Object)CurrentOperatingSystem.OS);
            }
        }
        return autoStartPath;
    }

    public String enableAutoStart(String windowsRunTreeKey, String linuxIconSource, String linuxIconFileName, String linuxDesktopFileTemplate, String linuxDesktopFileName) {
        if (this.isIDE_Start) {
            LOGGER.warning("this seems to be a start from within an IDE, autostart enabling skipped");
            return null;
        }
        String errorMessage = null;
        String unsupported = " is not supported!";
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                errorMessage = this.enableLinuxAutostart(linuxIconSource, linuxIconFileName, linuxDesktopFileTemplate, linuxDesktopFileName);
                break;
            }
            case Windows: {
                errorMessage = this.enableWindowsAutoStart(windowsRunTreeKey);
                break;
            }
            case Mac_OS_X: {
                this.enableMacOSXAutostart();
                break;
            }
            default: {
                errorMessage = (Object)((Object)CurrentOperatingSystem.OS) + unsupported;
            }
        }
        return errorMessage;
    }

    public String disableAutoStart(String windowsRunTreeKey, String linuxIconFileName, String linuxDesktopFileName) {
        String errorMessage = null;
        String unsupported = " is not supported!";
        switch (CurrentOperatingSystem.OS) {
            case Linux: {
                AutoStarter.disableLinuxAutostart(linuxDesktopFileName, linuxIconFileName);
                break;
            }
            case Mac_OS_X: {
                this.disableMACOSXAutostart();
                break;
            }
            case Windows: {
                errorMessage = this.disableWindowsAutoStart(windowsRunTreeKey);
                break;
            }
            default: {
                errorMessage = (Object)((Object)CurrentOperatingSystem.OS) + unsupported;
            }
        }
        return errorMessage;
    }

    private String getPathToJAR() {
        String userDir = System.getProperty("user.dir");
        LOGGER.log(Level.FINEST, "userDir = {0}", userDir);
        String javaClassPath = System.getProperty("java.class.path");
        LOGGER.log(Level.FINEST, "javaClassPath = {0}", javaClassPath);
        if (CurrentOperatingSystem.OS == OperatingSystem.Windows && javaClassPath.charAt(1) == ':') {
            return javaClassPath;
        }
        if (javaClassPath.startsWith(File.separator)) {
            return javaClassPath;
        }
        return userDir + File.separator + javaClassPath;
    }

    private String enableWindowsAutoStart(String windowsRunTreeKey) {
        String errorMessage;
        try {
            WinRegistry winRegistry = new WinRegistry();
            errorMessage = winRegistry.setValue(WINDOWS_RUN_TREE, windowsRunTreeKey, this.startCommand, false);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    private String disableWindowsAutoStart(String windowsRunTreeKey) {
        String errorMessage;
        try {
            WinRegistry winRegistry = new WinRegistry();
            errorMessage = winRegistry.removeValue(WINDOWS_RUN_TREE, windowsRunTreeKey);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableMacOSXAutostart() {
        if (!this.osxScriptDir.exists() && !this.osxScriptDir.mkdirs()) {
            LOGGER.log(Level.WARNING, "could not create {0}", this.osxScriptDir);
            return;
        }
        File scriptFile = new File(this.osxScriptDir, "autostart.sh");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(scriptFile);
            fileWriter.write("#!/bin/sh" + LINE_SEPARATOR + this.startCommand);
            fileWriter.close();
            scriptFile.setExecutable(true);
            if (!OSX_LAUNCH_AGENTS_DIR.exists() && !OSX_LAUNCH_AGENTS_DIR.mkdirs()) {
                LOGGER.log(Level.WARNING, "could not create {0}", OSX_LAUNCH_AGENTS_DIR);
                return;
            }
            fileWriter = new FileWriter(this.osxLaunchAgentsFile);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LINE_SEPARATOR + "<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">" + LINE_SEPARATOR + "<plist version=\"1.0\">" + LINE_SEPARATOR + "<dict>" + LINE_SEPARATOR + "\t<key>Label</key>" + LINE_SEPARATOR + "\t<string>autostart</string>" + LINE_SEPARATOR + "\t<key>ProgramArguments</key>" + LINE_SEPARATOR + "\t<array>" + LINE_SEPARATOR + "\t\t<string>" + scriptFile + "</string>" + LINE_SEPARATOR + "\t</array>" + LINE_SEPARATOR + "\t<key>RunAtLoad</key>" + LINE_SEPARATOR + "\t<true/>" + LINE_SEPARATOR + "</dict>" + LINE_SEPARATOR + "</plist>");
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "could not enable autostart", ex);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void disableMACOSXAutostart() {
        try {
            FileTools.recursiveDelete(this.osxScriptDir, true);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "could not delete " + this.osxScriptDir, ex);
        }
        AutoStarter.deleteIfExists(this.osxLaunchAgentsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String enableLinuxAutostart(String iconSource, String iconDestination, String desktopFileTemplate, String desktopFileName) {
        InputStream iconInputStream = null;
        FileOutputStream iconOutputStream = null;
        try {
            iconInputStream = AutoStarter.class.getResourceAsStream(iconSource);
            File iconFile = new File(iconDestination);
            if (!iconFile.exists()) {
                File parentFile = iconFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    LOGGER.log(Level.WARNING, "could not create directory {0}", parentFile);
                }
                if (!iconFile.createNewFile()) {
                    LOGGER.log(Level.WARNING, "could not create {0}", iconFile);
                }
            }
            iconOutputStream = new FileOutputStream(iconFile);
            byte[] buffer = new byte[1000];
            int bytesRead = iconInputStream.read(buffer);
            while (bytesRead != -1) {
                iconOutputStream.write(buffer, 0, bytesRead);
                bytesRead = iconInputStream.read(buffer);
            }
            LOGGER.log(Level.INFO, "icon copied to {0}", iconDestination);
            String contents = MessageFormat.format(desktopFileTemplate, iconDestination, this.startCommand);
            AutoStarter.writeDesktopFile(FREE_DESKTOP_AUTOSTART_DIR, desktopFileName, contents);
            String kdeFullSession = System.getenv("KDE_FULL_SESSION");
            if (kdeFullSession != null && kdeFullSession.equals("true") && System.getenv("KDE_SESSION_VERSION") == null) {
                AutoStarter.writeDesktopFile(KDE_AUTOSTART_DIR, desktopFileName, contents);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "could not enable Linux autostart", ex);
            String string = ex.getMessage();
            return string;
        }
        finally {
            if (iconInputStream != null) {
                try {
                    iconInputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            if (iconOutputStream != null) {
                try {
                    iconOutputStream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDesktopFile(File autoStartFolder, String fileName, String contents) throws IOException {
        if (!autoStartFolder.exists() && !autoStartFolder.mkdirs()) {
            LOGGER.log(Level.WARNING, "could not create ", autoStartFolder);
            return;
        }
        File desktopFile = new File(autoStartFolder, fileName + ".desktop");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(desktopFile);
            fileOutputStream.write(contents.getBytes());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        LOGGER.log(Level.INFO, "desktop file {0} created", desktopFile);
        if (!desktopFile.setExecutable(true)) {
            LOGGER.log(Level.WARNING, "failed to make {0} executable", desktopFile);
        }
    }

    private static void disableLinuxAutostart(String desktopFileName, String iconFileName) {
        AutoStarter.deleteIfExists(new File(FREE_DESKTOP_AUTOSTART_DIR, desktopFileName + ".desktop"));
        AutoStarter.deleteIfExists(new File(KDE_AUTOSTART_DIR, desktopFileName + ".desktop"));
        AutoStarter.deleteIfExists(new File(iconFileName));
    }

    private static void deleteIfExists(File file) {
        if (file.exists()) {
            if (file.delete()) {
                LOGGER.log(Level.INFO, "{0} deleted", file);
            } else {
                LOGGER.log(Level.WARNING, "could not delete {0}", file);
            }
        } else {
            LOGGER.log(Level.INFO, "{0} does not exist", file);
        }
    }
}

