/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.IconManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MacOSXSetupHelpFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(MacOSXSetupHelpFrame.class.getName());
    private JEditorPane editorPane;
    private JLabel errorLabel;
    private JButton okButton;

    public MacOSXSetupHelpFrame() {
        this.initComponents();
        this.errorLabel.setIcon(IconManager.ERROR_ICON);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        Class<?> thisClass = this.getClass();
        String installationFileName = bundle.getString("Mac_OS_X_Installation_File");
        URL fileURL = thisClass.getResource(installationFileName);
        try {
            this.editorPane.setPage(fileURL);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "could not load Mac OS X Installation file", ex);
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.errorLabel = new JLabel();
        this.editorPane = new JEditorPane();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("MacOSXSetupHelpFrame.title"));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.errorLabel.setText(bundle.getString("MacOSXSetupHelpFrame.errorLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.errorLabel, gridBagConstraints);
        this.editorPane.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.editorPane.setBorder(null);
        this.editorPane.setContentType(bundle.getString("MacOSXSetupHelpFrame.editorPane.contentType"));
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                MacOSXSetupHelpFrame.this.editorPaneHyperlinkUpdate(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.editorPane, gridBagConstraints);
        this.okButton.setText(bundle.getString("MacOSXSetupHelpFrame.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacOSXSetupHelpFrame.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
    }

    private void editorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
            final JEditorPane source = (JEditorPane)evt.getSource();
            Thread guiThread = new Thread(){

                public void run() {
                    source.setEnabled(false);
                    MacOSXSetupHelpFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    source.setEnabled(true);
                    MacOSXSetupHelpFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            guiThread.start();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }
}

