/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.EncryptionCleanupSwingWorker;
import ch.fhnw.jbackpack.EncryptionFinishSwingWorker;
import ch.fhnw.jbackpack.RsyncCopyDialog;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionSwingWorker
extends SwingWorker<Boolean, Void> {
    private static final Logger LOGGER = Logger.getLogger(EncryptionSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final String destinationPath;
    private final File encfsPlainDir;
    private final String encfsCipherPath;
    private final String password;
    private final RsyncCopyDialog rsyncCopyDialog;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;
    private boolean cancelled;

    public EncryptionSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, String destinationPath, File encfsPlainDir, String encfsCipherPath, String password) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.destinationPath = destinationPath;
        this.encfsPlainDir = encfsPlainDir;
        this.encfsCipherPath = encfsCipherPath;
        this.password = password;
        this.processExecutor = new ProcessExecutor();
        this.rsyncCopyDialog = new RsyncCopyDialog(parentFrame, BUNDLE.getString("Encrypting_Destination_Directory"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/encryption_animation.gif")), this.processExecutor);
        this.dialogHandler = new ModalDialogHandler(this.rsyncCopyDialog);
        this.processExecutor.addPropertyChangeListener(this.rsyncCopyDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Boolean doInBackground() {
        int returnValue = CurrentOperatingSystem.OS == OperatingSystem.Linux ? this.processExecutor.executeProcess(false, true, "rsync", "-rv", "--no-inc-recursive", "--progress", this.destinationPath + File.separatorChar, this.encfsPlainDir.getPath() + File.separatorChar) : this.processExecutor.executeProcess(false, true, "rsync", "-rv", "--progress", this.destinationPath + File.separatorChar, this.encfsPlainDir.getPath() + File.separatorChar);
        this.cancelled = this.rsyncCopyDialog.isCancelPressed();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        if (!FileTools.umountFUSE(this.encfsPlainDir, false)) {
            return false;
        }
        if (returnValue == 0) {
            EncryptionFinishSwingWorker encryptionFinishSwingWorker = new EncryptionFinishSwingWorker(this.parentFrame, this.backupMainPanel, this.destinationPath, this.encfsPlainDir, this.encfsCipherPath, this.password);
            encryptionFinishSwingWorker.execute();
            return true;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "rsync error messages:{0}{1}", new Object[]{LINE_SEPARATOR, this.processExecutor.getStdErr()});
        }
        EncryptionCleanupSwingWorker encryptionCleanupSwingWorker = new EncryptionCleanupSwingWorker(this.parentFrame, this.encfsCipherPath, this.encfsPlainDir, this.cancelled);
        encryptionCleanupSwingWorker.execute();
        return false;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
        try {
            if (!((Boolean)this.get()).booleanValue() && !this.cancelled) {
                JOptionPane.showMessageDialog(this.parentFrame, BUNDLE.getString("Encryption_Failed"), BUNDLE.getString("Error"), 0);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }
}

