/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditReminderDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private boolean okButtonClicked;
    private int reminderTimeout;
    private JButton cancelButton;
    private JButton okButton;
    private JCheckBox reminderCheckBox;
    private JLabel reminderLabel;
    private JSpinner reminderSpinner;

    public EditReminderDialog(Frame parent, boolean reminder, int reminderTimeout) {
        super(parent, true);
        this.reminderTimeout = reminderTimeout;
        this.initComponents();
        this.reminderCheckBox.setSelected(reminder);
        this.reminderCheckBoxActionPerformed(null);
        if (reminderTimeout > 0) {
            this.reminderSpinner.setValue(reminderTimeout);
        } else {
            this.reminderSpinner.setValue(1);
        }
        this.updateReminderLabel(reminderTimeout);
        this.setLocationRelativeTo(parent);
    }

    public boolean okSelected() {
        return this.okButtonClicked;
    }

    public boolean isReminderSelected() {
        return this.reminderCheckBox.isSelected();
    }

    public int getReminderTimeout() {
        return this.reminderTimeout;
    }

    private void initComponents() {
        this.reminderCheckBox = new JCheckBox();
        this.reminderSpinner = new JSpinner();
        this.reminderLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("EditReminderDialog.title"));
        this.reminderCheckBox.setText(bundle.getString("EditReminderDialog.reminderCheckBox.text"));
        this.reminderCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditReminderDialog.this.reminderCheckBoxActionPerformed(evt);
            }
        });
        this.reminderSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.reminderSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                EditReminderDialog.this.reminderSpinnerStateChanged(evt);
            }
        });
        this.reminderLabel.setText(bundle.getString("Days"));
        this.reminderLabel.setEnabled(false);
        this.okButton.setText(bundle.getString("EditReminderDialog.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditReminderDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("EditReminderDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditReminderDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reminderCheckBox, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.reminderSpinner, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reminderLabel))).addContainerGap(24, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(127, Short.MAX_VALUE).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.cancelButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.reminderCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reminderSpinner, -2, -1, -2).addComponent(this.reminderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void reminderCheckBoxActionPerformed(ActionEvent evt) {
        boolean selected = this.reminderCheckBox.isSelected();
        this.reminderSpinner.setEnabled(selected);
        this.reminderLabel.setEnabled(selected);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.reminderCheckBox.isSelected()) {
            String timeoutText = this.reminderSpinner.getValue().toString();
            if (timeoutText.isEmpty()) {
                this.reminderSpinner.requestFocusInWindow();
                this.showError(BUNDLE.getString("Error_No_Timeout"));
                return;
            }
            try {
                this.reminderTimeout = Integer.parseInt(timeoutText);
                if (this.reminderTimeout <= 0) {
                    this.showError(BUNDLE.getString("Error_Timeout_No_Positive_Integer"));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showError(BUNDLE.getString("Error_Timeout_No_Positive_Integer"));
                return;
            }
        }
        this.okButtonClicked = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void reminderSpinnerStateChanged(ChangeEvent evt) {
        int value = (Integer)this.reminderSpinner.getValue();
        this.updateReminderLabel(value);
    }

    private void updateReminderLabel(int value) {
        this.reminderLabel.setText(BUNDLE.getString(value == 1 ? "Day" : "Days"));
    }

    private void showError(String errorMessage) {
        JOptionPane.showMessageDialog(this, errorMessage, BUNDLE.getString("Error"), 0);
        this.reminderSpinner.requestFocusInWindow();
    }
}

