/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.JSqueezedLabel;
import ch.fhnw.util.FileTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DirectoryCheckDialog
extends JDialog {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parent;
    private long freeSpace;
    private JLabel currentFileLabel;
    private JLabel fileCounterLabel;
    private JPanel filenameCheckPanel;
    private JLabel freeSpaceLabel;
    private JTextField freeSpaceTextField;
    private JLabel lengthStatusLabel;
    private JTextField lengthStatusTextField;
    private JLabel maxLengthLabel;
    private JTextField maxLengthTextField;
    private JProgressBar progressBar;
    private JPanel sizeCheckPanel;
    private JLabel sizeLabel;
    private JTextField sizeTextField;

    public DirectoryCheckDialog(Frame parent) {
        super(parent, true);
        this.parent = parent;
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setFilenameCheckEnabled(boolean enabled, int maximumFilenameLength) {
        this.filenameCheckPanel.setVisible(enabled);
        if (enabled) {
            String text = BUNDLE.getString("Nr_Of_Characters");
            text = MessageFormat.format(text, maximumFilenameLength);
            this.maxLengthTextField.setText(text);
        } else {
            this.pack();
            this.setLocationRelativeTo(this.parent);
        }
    }

    public void setFreeSpaceKnown(boolean known, long freeSpace) {
        if (known) {
            this.freeSpace = freeSpace;
            this.freeSpaceTextField.setText(FileTools.getDataVolumeString(freeSpace, 1));
        } else {
            this.freeSpaceTextField.setText(BUNDLE.getString("Unknown"));
        }
    }

    public void setFileCount(long fileCount) {
        String text = BUNDLE.getString("Checking_File");
        text = MessageFormat.format(text, fileCount);
        this.fileCounterLabel.setText(text);
    }

    public void setCurrentFile(String currentFile) {
        this.currentFileLabel.setText(currentFile);
    }

    public void setCurrentSize(long size) {
        this.sizeTextField.setText(FileTools.getDataVolumeString(size, 1));
        if (this.freeSpace != 0L) {
            int progress = (int)(100L * size / this.freeSpace);
            this.progressBar.setValue(progress);
            this.progressBar.setString(progress + "%");
        }
    }

    public void setFilenameCheckstatus(boolean fine) {
        if (fine) {
            this.lengthStatusTextField.setText(BUNDLE.getString("OK"));
            this.lengthStatusTextField.setForeground(Color.GREEN);
        } else {
            this.lengthStatusTextField.setText(BUNDLE.getString("Error"));
            this.lengthStatusTextField.setForeground(Color.RED);
        }
    }

    private void initComponents() {
        this.fileCounterLabel = new JLabel();
        this.currentFileLabel = new JSqueezedLabel();
        this.sizeCheckPanel = new JPanel();
        this.freeSpaceLabel = new JLabel();
        this.freeSpaceTextField = new JTextField();
        this.sizeLabel = new JLabel();
        this.sizeTextField = new JTextField();
        this.progressBar = new JProgressBar();
        this.filenameCheckPanel = new JPanel();
        this.maxLengthLabel = new JLabel();
        this.maxLengthTextField = new JTextField();
        this.lengthStatusLabel = new JLabel();
        this.lengthStatusTextField = new JTextField();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("DirectoryCheckDialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.fileCounterLabel.setText(bundle.getString("Checking_File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.fileCounterLabel, gridBagConstraints);
        this.currentFileLabel.setFont(this.currentFileLabel.getFont().deriveFont(this.currentFileLabel.getFont().getStyle() & 0xFFFFFFFE, this.currentFileLabel.getFont().getSize() - 1));
        this.currentFileLabel.setText(bundle.getString("DirectoryCheckDialog.currentFileLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.getContentPane().add((Component)this.currentFileLabel, gridBagConstraints);
        this.sizeCheckPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("DirectoryCheckDialog.sizeCheckPanel.border.title")));
        this.freeSpaceLabel.setText(bundle.getString("DirectoryCheckDialog.freeSpaceLabel.text"));
        this.freeSpaceTextField.setColumns(7);
        this.freeSpaceTextField.setEditable(false);
        this.sizeLabel.setText(bundle.getString("DirectoryCheckDialog.sizeLabel.text"));
        this.sizeTextField.setColumns(7);
        this.sizeTextField.setEditable(false);
        this.progressBar.setStringPainted(true);
        GroupLayout sizeCheckPanelLayout = new GroupLayout(this.sizeCheckPanel);
        this.sizeCheckPanel.setLayout(sizeCheckPanelLayout);
        sizeCheckPanelLayout.setHorizontalGroup(sizeCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizeCheckPanelLayout.createSequentialGroup().addContainerGap().addGroup(sizeCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizeCheckPanelLayout.createSequentialGroup().addComponent(this.freeSpaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freeSpaceTextField, -1, 177, Short.MAX_VALUE)).addGroup(sizeCheckPanelLayout.createSequentialGroup().addComponent(this.sizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sizeTextField, -1, 177, Short.MAX_VALUE)).addComponent(this.progressBar, -1, 373, Short.MAX_VALUE)).addContainerGap()));
        sizeCheckPanelLayout.linkSize(0, this.freeSpaceLabel, this.sizeLabel);
        sizeCheckPanelLayout.setVerticalGroup(sizeCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sizeCheckPanelLayout.createSequentialGroup().addGroup(sizeCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.freeSpaceLabel).addComponent(this.freeSpaceTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sizeCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sizeLabel).addComponent(this.sizeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.sizeCheckPanel, gridBagConstraints);
        this.filenameCheckPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("DirectoryCheckDialog.filenameCheckPanel.border.title")));
        this.maxLengthLabel.setText(bundle.getString("DirectoryCheckDialog.maxLengthLabel.text"));
        this.maxLengthTextField.setEditable(false);
        this.lengthStatusLabel.setText(bundle.getString("DirectoryCheckDialog.lengthStatusLabel.text"));
        this.lengthStatusTextField.setEditable(false);
        GroupLayout filenameCheckPanelLayout = new GroupLayout(this.filenameCheckPanel);
        this.filenameCheckPanel.setLayout(filenameCheckPanelLayout);
        filenameCheckPanelLayout.setHorizontalGroup(filenameCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filenameCheckPanelLayout.createSequentialGroup().addContainerGap().addGroup(filenameCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filenameCheckPanelLayout.createSequentialGroup().addComponent(this.maxLengthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxLengthTextField, -1, 181, Short.MAX_VALUE)).addGroup(filenameCheckPanelLayout.createSequentialGroup().addComponent(this.lengthStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lengthStatusTextField, -1, 181, Short.MAX_VALUE))).addContainerGap()));
        filenameCheckPanelLayout.linkSize(0, this.lengthStatusLabel, this.maxLengthLabel);
        filenameCheckPanelLayout.setVerticalGroup(filenameCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filenameCheckPanelLayout.createSequentialGroup().addGroup(filenameCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLengthLabel).addComponent(this.maxLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filenameCheckPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lengthStatusLabel).addComponent(this.lengthStatusTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this.filenameCheckPanel, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 437) / 2, (screenSize.height - 334) / 2, 437, 334);
    }
}

