/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.BackupMainPanel;
import ch.fhnw.jbackpack.DecryptionCleanupSwingWorker;
import ch.fhnw.jbackpack.DecryptionFinishSwingWorker;
import ch.fhnw.jbackpack.RsyncCopyDialog;
import ch.fhnw.util.CurrentOperatingSystem;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.ModalDialogHandler;
import ch.fhnw.util.OperatingSystem;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Frame;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptionSwingWorker
extends SwingWorker<Void, Void> {
    private static final Logger LOGGER = Logger.getLogger(DecryptionSwingWorker.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private final Frame parentFrame;
    private final BackupMainPanel backupMainPanel;
    private final File cipherDir;
    private final File plainDir;
    private final RsyncCopyDialog rsyncCopyDialog;
    private final ModalDialogHandler dialogHandler;
    private final ProcessExecutor processExecutor;
    private boolean cancelled;

    public DecryptionSwingWorker(Frame parentFrame, BackupMainPanel backupMainPanel, File cipherDir, File plainDir) {
        this.parentFrame = parentFrame;
        this.backupMainPanel = backupMainPanel;
        this.cipherDir = cipherDir;
        this.plainDir = plainDir;
        this.processExecutor = new ProcessExecutor();
        this.rsyncCopyDialog = new RsyncCopyDialog(parentFrame, BUNDLE.getString("Decrypting_Destination_Directory"), new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/decryption_animation.gif")), this.processExecutor);
        this.dialogHandler = new ModalDialogHandler(this.rsyncCopyDialog);
        this.processExecutor.addPropertyChangeListener(this.rsyncCopyDialog);
        this.dialogHandler.show();
    }

    @Override
    protected Void doInBackground() {
        File parentDir = this.cipherDir.getParentFile();
        String tmpPlainPath = FileTools.createTempDirectory(parentDir, this.cipherDir.getName() + ".plain").getPath();
        int returnValue = CurrentOperatingSystem.OS == OperatingSystem.Linux ? this.processExecutor.executeProcess("rsync", "-rv", "--no-inc-recursive", "--progress", this.plainDir.getPath() + File.separatorChar, tmpPlainPath + File.separatorChar) : this.processExecutor.executeProcess("rsync", "-rv", "--progress", this.plainDir.getPath() + File.separatorChar, tmpPlainPath + File.separatorChar);
        this.cancelled = this.rsyncCopyDialog.isCancelPressed();
        if (returnValue == 0) {
            DecryptionFinishSwingWorker decryptionFinishSwingWorker = new DecryptionFinishSwingWorker(this.parentFrame, this.backupMainPanel, this.cipherDir, this.plainDir, tmpPlainPath);
            decryptionFinishSwingWorker.execute();
        } else {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "rsync from {0} to {1} failed", new Object[]{this.plainDir, tmpPlainPath});
            }
            DecryptionCleanupSwingWorker decryptionCleanupSwingWorker = new DecryptionCleanupSwingWorker(this.parentFrame, tmpPlainPath, this.cancelled);
            decryptionCleanupSwingWorker.execute();
        }
        return null;
    }

    @Override
    protected void done() {
        this.dialogHandler.hide();
    }
}

