/* Copyright 2005 by Stefan Thesing
<p>This program is free software; you can 
redistribute it and/or modify it under the terms 
of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of 
the License, or (at your option) any later version.</p>
<p>This program is distributed in the hope that it 
will be useful, but WITHOUT ANY WARRANTY; without 
even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
General Public License for more details.</p>
<p>You should have received a copy of the GNU 
General Public License along with this program; 
if not, write to the <br>
Free Software Foundation, Inc.,<br>
51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.<br>
*/
package de.webdings.tools.time;


/**
 * EasyDateCreateException is used in the contstruction
 * of {@link EasyDate}.
 * Its thrown when an invalid month-value is specified.
 * @author Copyright 2005 by Stefan Thesing
 * Website: <a href="http://www.webdings.de">http://www.webdings.de</a>
 * @version 1.0 Created on 23.05.2005
 * @see EasyDate
 * 
 */
public class EasyDateCreateException extends java.lang.Exception {
    public EasyDateCreateException(int month) {
		super("EasyDate could not be created. " + month + " is not a valid month-value. Note that January is represented by 1 not by 0!");
	}
}
