/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.sitemap.PatternException;

public abstract class AbstractProcessingNodeBuilder
extends AbstractLogEnabled
implements ProcessingNodeBuilder,
Recomposable {
    protected TreeBuilder treeBuilder;
    protected ComponentManager manager;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void setBuilder(TreeBuilder treeBuilder) {
        this.treeBuilder = treeBuilder;
    }

    protected boolean hasParameters() {
        return true;
    }

    protected Map getParameters(Configuration config) throws ConfigurationException {
        Configuration[] children = config.getChildren("parameter");
        if (children.length == 0) {
            return Collections.singletonMap("org.apache.cocoon.sitemap/Location", config.getLocation());
        }
        HashMap<Object, Object> params = new HashMap<Object, Object>(children.length + 1);
        params.put("org.apache.cocoon.sitemap/Location", config.getLocation());
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(VariableResolverFactory.getResolver(name, this.manager), VariableResolverFactory.getResolver(value, this.manager));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + " at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
        }
        return params;
    }

    protected void checkNamespace(Configuration config) throws ConfigurationException {
        if (!this.treeBuilder.getNamespace().equals(config.getNamespace())) {
            String msg = "Invalid namespace '" + config.getNamespace() + "' at " + config.getLocation();
            throw new ConfigurationException(msg);
        }
    }
}

