/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.avalon.excalibur.monitor.StreamResource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public final class SourceResource
extends StreamResource {
    private final Source m_source;
    private SourceValidity m_validity;

    public SourceResource(Source source) throws Exception {
        super(source.getURI());
        this.m_source = source;
        this.setPreviousModified(System.currentTimeMillis());
        this.m_validity = source.getValidity();
    }

    public long lastModified() {
        if (null == this.m_validity) {
            return System.currentTimeMillis();
        }
        int valid = this.m_validity.isValid();
        boolean isValid = false;
        SourceValidity newVal = null;
        if (valid == 0) {
            this.m_source.refresh();
            newVal = this.m_source.getValidity();
            if (newVal != null) {
                valid = this.m_validity.isValid(newVal);
                isValid = valid == 1;
            }
        } else {
            boolean bl = isValid = valid == 1;
        }
        if (isValid) {
            return this.getPreviousModified();
        }
        if (null == newVal) {
            this.m_source.refresh();
            this.m_validity = this.m_source.getValidity();
        }
        return System.currentTimeMillis();
    }

    public InputStream getResourceAsStream() throws IOException {
        try {
            return this.m_source.getInputStream();
        }
        catch (SourceException se) {
            throw new IOException("SourceException: " + se.getMessage());
        }
    }

    public Reader getResourceAsReader() throws IOException {
        return new InputStreamReader(this.getResourceAsStream());
    }

    public OutputStream setResourceAsStream() throws IOException {
        throw new IOException("setResourceAsStream() not supported for URLResource");
    }

    public Writer setResourceAsWriter() throws IOException {
        throw new IOException("setResourceAsWriter() not supported for URLResource");
    }

    public Source getSource() {
        return this.m_source;
    }
}

