/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;

class ClassFileInfo
extends OpenableElementInfo {
    protected IJavaElement[] fBinaryChildren = null;
    protected IClassFile fClassFile = null;

    ClassFileInfo(IClassFile classFile) {
        this.fClassFile = classFile;
    }

    private void generateFieldInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList children) {
        IBinaryField[] fields = typeInfo.getFields();
        if (fields == null) {
            return;
        }
        int i = 0;
        int fieldCount = fields.length;
        while (i < fieldCount) {
            IBinaryField fieldInfo = fields[i];
            BinaryField field = new BinaryField(type, new String(fieldInfo.getName()));
            newElements.put(field, fieldInfo);
            children.add(field);
            ++i;
        }
    }

    private void generateInnerClassInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList children) {
        IBinaryNestedType[] innerTypes = typeInfo.getMemberTypes();
        if (innerTypes != null) {
            int i = 0;
            int typeCount = innerTypes.length;
            while (i < typeCount) {
                IBinaryNestedType binaryType = innerTypes[i];
                IClassFile classFile = ((IPackageFragment)this.fClassFile.getParent()).getClassFile(String.valueOf(new String(ClassFile.unqualifiedName(binaryType.getName()))) + ".class");
                BinaryType innerType = new BinaryType(classFile, new String(ClassFile.simpleName(binaryType.getName())));
                children.add(innerType);
                ++i;
            }
        }
    }

    private void generateMethodInfos(IType type, IBinaryType typeInfo, HashMap newElements, ArrayList children) {
        IBinaryMethod[] methods = typeInfo.getMethods();
        if (methods == null) {
            return;
        }
        int i = 0;
        int methodCount = methods.length;
        while (i < methodCount) {
            IBinaryMethod methodInfo = methods[i];
            String[] pNames = Signature.getParameterTypes(new String(methodInfo.getMethodDescriptor()));
            char[][] paramNames = new char[pNames.length][];
            int j = 0;
            while (j < pNames.length) {
                paramNames[j] = pNames[j].toCharArray();
                ++j;
            }
            char[][] parameterTypes = ClassFile.translatedNames(paramNames);
            String selector = new String(methodInfo.getSelector());
            if (methodInfo.isConstructor()) {
                selector = type.getElementName();
            }
            int j2 = 0;
            while (j2 < pNames.length) {
                pNames[j2] = new String(parameterTypes[j2]);
                ++j2;
            }
            BinaryMethod method = new BinaryMethod(type, selector, pNames);
            children.add(method);
            newElements.put(method, methodInfo);
            ++i;
        }
    }

    IJavaElement[] getBinaryChildren() throws JavaModelException {
        if (this.fBinaryChildren == null) {
            this.readBinaryChildren();
        }
        return this.fBinaryChildren;
    }

    boolean hasReadBinaryChildren() {
        return this.fBinaryChildren != null;
    }

    private void readBinaryChildren() {
        ArrayList children = new ArrayList();
        HashMap newElements = new HashMap();
        BinaryType type = null;
        IBinaryType typeInfo = null;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            type = (BinaryType)this.fClassFile.getType();
            typeInfo = (IBinaryType)manager.getInfo(type);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        if (typeInfo != null) {
            this.generateFieldInfos(type, typeInfo, newElements, children);
            this.generateMethodInfos(type, typeInfo, newElements, children);
            this.generateInnerClassInfos(type, typeInfo, newElements, children);
        }
        Iterator iter = newElements.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            manager.putInfo((IJavaElement)entry.getKey(), entry.getValue());
        }
        this.fBinaryChildren = new IJavaElement[children.size()];
        children.toArray(this.fBinaryChildren);
    }

    void removeBinaryChildren() {
        if (this.fBinaryChildren != null) {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            int i = 0;
            while (i < this.fBinaryChildren.length) {
                manager.removeInfo(this.fBinaryChildren[i]);
                ++i;
            }
            this.fBinaryChildren = JavaElementInfo.fgEmptyChildren;
        }
    }
}

