/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class ImportReference
extends AstNode {
    public char[][] tokens;
    public long[] sourcePositions;
    public boolean onDemand = true;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public boolean used;

    public ImportReference(char[][] sources, long[] poss, boolean d) {
        this.tokens = sources;
        this.sourcePositions = poss;
        this.onDemand = d;
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
    }

    public char[][] getImportName() {
        return this.tokens;
    }

    public String toString(int tab) {
        return this.toString(tab, true);
    }

    public String toString(int tab, boolean withOnDemand) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.length) {
            buffer.append(this.tokens[i]);
            if (i < this.tokens.length - 1) {
                buffer.append(".");
            }
            ++i;
        }
        if (withOnDemand && this.onDemand) {
            buffer.append(".*");
        }
        return buffer.toString();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, CompilationUnitScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

