/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.eval.CodeSnippetClassFile;

public class CodeSnippetTypeDeclaration
extends TypeDeclaration {
    public CodeSnippetTypeDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void generateCode(ClassFile enclosingClassFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        this.hasBeenGenerated = true;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CodeSnippetClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int max;
            int i;
            CodeSnippetClassFile classFile = new CodeSnippetClassFile(this.binding, enclosingClassFile, false);
            classFile.addFieldInfos();
            if (this.binding.isMemberType()) {
                classFile.recordEnclosingTypeAttributes(this.binding);
            }
            if (this.binding.isLocalType()) {
                enclosingClassFile.recordNestedLocalAttribute(this.binding);
                classFile.recordNestedLocalAttribute(this.binding);
            }
            if (this.memberTypes != null) {
                i = 0;
                max = this.memberTypes.length;
                while (i < max) {
                    classFile.recordNestedMemberAttribute(this.memberTypes[i].binding);
                    this.memberTypes[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.setForMethodInfos();
            if (this.methods != null) {
                i = 0;
                max = this.methods.length;
                while (i < max) {
                    this.methods[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult);
            }
            classFile.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            CodeSnippetClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }
}

