/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SaveIndex
extends IndexRequest {
    public SaveIndex(IPath indexPath, IndexManager manager) {
        super(indexPath, manager);
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterWrite();
                this.manager.saveIndex(index);
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to save index " + this.indexPath + " because of the following exception:");
                    e.printStackTrace();
                }
                Object var5_5 = null;
                monitor.exitWrite();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.exitWrite();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.exitWrite();
        return true;
    }

    public String toString() {
        return "saving index for " + this.indexPath;
    }
}

