/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClasspathEntry
implements IClasspathEntry {
    public int entryKind;
    public int contentKind;
    public IPath path;
    public IPath[] exclusionPatterns;
    private char[][] fullCharExclusionPatterns;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private String rootID;
    public static final IPath[] NO_EXCLUSION_PATTERNS = new IPath[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public boolean isExported;

    public ClasspathEntry(int contentKind, int entryKind, IPath path, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, boolean isExported) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.exclusionPatterns = exclusionPatterns;
        if (exclusionPatterns.length > 0) {
            this.fullCharExclusionPatterns = UNINIT_PATTERNS;
        }
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputLocation = specificOutputLocation;
        this.isExported = isExported;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullCharExclusionPatterns == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullCharExclusionPatterns = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullCharExclusionPatterns[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullCharExclusionPatterns;
    }

    public Element elementEncode(Document document, IPath projectPath) throws JavaModelException {
        Element element = document.createElement("classpathentry");
        element.setAttribute("kind", ClasspathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        element.setAttribute("path", xmlPath.toString());
        if (this.sourceAttachmentPath != null) {
            element.setAttribute("sourcepath", this.sourceAttachmentPath.toString());
        }
        if (this.sourceAttachmentRootPath != null) {
            element.setAttribute("rootpath", this.sourceAttachmentRootPath.toString());
        }
        if (this.isExported) {
            element.setAttribute("exported", "true");
        }
        if (this.exclusionPatterns.length > 0) {
            StringBuffer excludeRule = new StringBuffer(10);
            int i = 0;
            int max = this.exclusionPatterns.length;
            while (i < max) {
                if (i > 0) {
                    excludeRule.append('|');
                }
                excludeRule.append(this.exclusionPatterns[i]);
                ++i;
            }
            element.setAttribute("excluding", excludeRule.toString());
        }
        if (this.specificOutputLocation != null) {
            IPath outputLocation = this.specificOutputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            element.setAttribute("output", outputLocation.toString());
        }
        return element;
    }

    public static IClasspathEntry elementDecode(Element element, IJavaProject project) {
        char[][] patterns;
        int patternCount;
        IPath projectPath = project.getProject().getFullPath();
        String kindAttr = element.getAttribute("kind");
        String pathAttr = element.getAttribute("path");
        Path path = new Path(pathAttr);
        int kind = ClasspathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path sourceAttachmentPath = element.hasAttribute("sourcepath") ? new Path(element.getAttribute("sourcepath")) : null;
        Path sourceAttachmentRootPath = element.hasAttribute("rootpath") ? new Path(element.getAttribute("rootpath")) : null;
        boolean isExported = element.getAttribute("exported").equals("true");
        String exclusion = element.getAttribute("excluding");
        IPath[] exclusionPatterns = NO_EXCLUSION_PATTERNS;
        if (!exclusion.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', exclusion.toCharArray())).length) > 0) {
            exclusionPatterns = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                exclusionPatterns[j] = new Path(new String(patterns[j]));
                ++j;
            }
        }
        IPath outputLocation = element.hasAttribute("output") ? projectPath.append(element.getAttribute("output")) : null;
        switch (kind) {
            case 2: {
                return JavaCore.newProjectEntry((IPath)path, isExported);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    return JavaCore.newSourceEntry((IPath)path, exclusionPatterns, outputLocation);
                }
                return JavaCore.newProjectEntry((IPath)path, isExported);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, isExported);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path, isExported);
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return new ClasspathEntry(10, 1, (IPath)path, NO_EXCLUSION_PATTERNS, null, null, null, false);
            }
        }
        throw new Assert.AssertionFailedException(Util.bind("classpath.unknownKind", kindAttr));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IClasspathEntry) {
            IClasspathEntry otherEntry = (IClasspathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            IPath otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals((Object)otherPath)) {
                return false;
            }
            IPath[] otherExcludes = otherEntry.getExclusionPatterns();
            if (this.exclusionPatterns != otherExcludes) {
                int excludeLength = this.exclusionPatterns.length;
                if (otherExcludes.length != excludeLength) {
                    return false;
                }
                int i = 0;
                while (i < excludeLength) {
                    if (!this.exclusionPatterns[i].toString().equals(otherExcludes[i].toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            otherPath = otherEntry.getOutputLocation();
            return !(this.specificOutputLocation == null ? otherPath != null : !this.specificOutputLocation.equals((Object)otherPath));
        }
        return false;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isExported() {
        return this.isExported;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase("output")) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return "output";
            }
        }
        return "unknown";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                buffer.append("K_BINARY");
                break;
            }
            case 1: {
                buffer.append("K_SOURCE");
                break;
            }
            case 10: {
                buffer.append("K_OUTPUT");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.getExclusionPatterns();
        int length = patterns.length;
        if (length > 0) {
            buffer.append("[excluding:");
            int i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            buffer.append("[output:");
            buffer.append(this.getOutputLocation());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public IClasspathEntry getResolvedEntry() {
        return JavaCore.getResolvedClasspathEntry(this);
    }
}

