/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement {
    public Statement statement;
    public char[] label;
    public Label targetLabel;
    int mergedInitStateIndex = -1;

    public LabeledStatement(char[] l, Statement st, int s, int e) {
        this.statement = st;
        this.label = l;
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        this.targetLabel = new Label();
        LabelFlowContext labelContext = new LabelFlowContext(flowContext, this, this.label, this.targetLabel, currentScope);
        UnconditionalFlowInfo mergedInfo = this.statement.analyseCode(currentScope, labelContext, flowInfo).mergedWith(labelContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public AstNode concreteStatement() {
        return this.statement;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        int pc = codeStream.position;
        if (this.targetLabel != null) {
            this.targetLabel.codeStream = codeStream;
            if (this.statement != null) {
                this.statement.generateCode(currentScope, codeStream);
            }
            this.targetLabel.place();
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
        this.statement.resolve(scope);
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + new String(this.label) + ": " + this.statement.toString(0);
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.statement.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    public void resetStateForCodeGeneration() {
        if (this.targetLabel != null) {
            this.targetLabel.resetStateForCodeGeneration();
        }
    }
}

