/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    private Label breakLabel;
    private Label continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] initializations, Expression condition, Statement[] increments, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.initializations = initializations;
        this.condition = condition;
        this.increments = increments;
        this.action = action;
        this.neededScope = neededScope;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        UnconditionalFlowInfo mergedInfo;
        LoopingFlowContext loopingContext;
        FlowInfo actionInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        if (this.initializations != null) {
            int count = this.initializations.length;
            int i = 0;
            while (i < count) {
                flowInfo = this.initializations[i++].analyseCode(this.scope, flowContext, flowInfo);
            }
        }
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != AstNode.NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != null && cst != AstNode.NotAConstant && !cst.booleanValue();
        cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst == null || cst != AstNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != null && cst != AstNode.NotAConstant && !cst.booleanValue();
        LoopingFlowContext condLoopContext = null;
        if (this.condition != null && !isConditionTrue) {
            condLoopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            flowInfo = this.condition.analyseCode(this.scope, condLoopContext, flowInfo);
        }
        if (this.action == null || this.action.isEmptyBlock() && currentScope.environment().options.complianceLevel <= 2) {
            if (condLoopContext != null) {
                condLoopContext.complainOnFinalAssignmentsInLoop(this.scope, flowInfo);
            }
            if (isConditionTrue) {
                return FlowInfo.DEAD_END;
            }
            if (isConditionFalse) {
                this.continueLabel = null;
            }
            actionInfo = flowInfo.initsWhenTrue().copy();
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        } else {
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
            FlowInfo initsWhenTrue = flowInfo.initsWhenTrue();
            this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(initsWhenTrue);
            if (isConditionFalse) {
                actionInfo = FlowInfo.DEAD_END;
            } else {
                actionInfo = initsWhenTrue.copy();
                if (isConditionOptimizedFalse) {
                    actionInfo.setReachMode(1);
                }
            }
            if (!actionInfo.complainIfUnreachable(this.action, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo);
            }
            if (!actionInfo.isReachable() && !loopingContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                if (condLoopContext != null) {
                    condLoopContext.complainOnFinalAssignmentsInLoop(this.scope, flowInfo);
                }
                loopingContext.complainOnFinalAssignmentsInLoop(this.scope, actionInfo);
                actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue.unconditionalInits());
            }
        }
        if (this.continueLabel != null && this.increments != null) {
            LoopingFlowContext loopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            int i = 0;
            int count = this.increments.length;
            while (i < count) {
                actionInfo = this.increments[i++].analyseCode(this.scope, loopContext, actionInfo);
            }
            loopContext.complainOnFinalAssignmentsInLoop(this.scope, actionInfo);
        }
        if (isConditionOptimizedTrue) {
            mergedInfo = loopingContext.initsOnBreak;
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            return mergedInfo;
        }
        mergedInfo = flowInfo.initsWhenFalse().unconditionalInits().mergedWith(loopingContext.initsOnBreak.unconditionalInits());
        if (isConditionOptimizedTrue && this.continueLabel == null) {
            ((FlowInfo)mergedInfo).setReachMode(1);
        }
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initializations != null) {
            int i = 0;
            int max = this.initializations.length;
            while (i < max) {
                this.initializations[i].generateCode(this.scope, codeStream);
                ++i;
            }
        }
        Label actionLabel = new Label(codeStream);
        Label conditionLabel = new Label(codeStream);
        this.breakLabel.codeStream = codeStream;
        if (this.continueLabel != null) {
            this.continueLabel.codeStream = codeStream;
        }
        if (this.condition != null && this.condition.constant == AstNode.NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
            int jumpPC = codeStream.position;
            codeStream.goto_(conditionLabel);
            codeStream.recordPositionsFrom(jumpPC, this.condition.sourceStart);
        }
        actionLabel.place();
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
            }
            this.action.generateCode(this.scope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                int i = 0;
                int max = this.increments.length;
                while (i < max) {
                    this.increments[i].generateCode(this.scope, codeStream);
                    ++i;
                }
            }
        }
        if (this.preCondInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
        }
        conditionLabel.place();
        if (this.condition != null && this.condition.constant == AstNode.NotAConstant) {
            this.condition.generateOptimizedBoolean(this.scope, codeStream, actionLabel, null, true);
        } else if (this.continueLabel != null) {
            codeStream.goto_(actionLabel);
        }
        this.breakLabel.place();
        if (this.neededScope) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
        if (this.continueLabel != null) {
            this.continueLabel.resetStateForCodeGeneration();
        }
    }

    public void resolve(BlockScope upperScope) {
        int length;
        BlockScope blockScope = this.scope = this.neededScope ? new BlockScope(upperScope) : upperScope;
        if (this.initializations != null) {
            int i = 0;
            length = this.initializations.length;
            while (i < length) {
                this.initializations[i].resolve(this.scope);
                ++i;
            }
        }
        if (this.condition != null) {
            TypeBinding type = this.condition.resolveTypeExpecting(this.scope, BaseTypes.BooleanBinding);
            this.condition.implicitWidening(type, type);
        }
        if (this.increments != null) {
            int i = 0;
            length = this.increments.length;
            while (i < length) {
                this.increments[i].resolve(this.scope);
                ++i;
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public String toString(int tab) {
        int i;
        String s = String.valueOf(AstNode.tabString(tab)) + "for (";
        if (!this.neededScope) {
            s = String.valueOf(s) + " //--NO upperscope scope needed\n" + AstNode.tabString(tab) + "     ";
        }
        if (this.initializations != null) {
            i = 0;
            while (i < this.initializations.length) {
                s = String.valueOf(s) + this.initializations[i].toString(0);
                if (i != this.initializations.length - 1) {
                    s = String.valueOf(s) + " , ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "; ";
        if (this.condition != null) {
            s = String.valueOf(s) + this.condition.toStringExpression();
        }
        s = String.valueOf(s) + "; ";
        if (this.increments != null) {
            i = 0;
            while (i < this.increments.length) {
                s = String.valueOf(s) + this.increments[i].toString(0);
                if (i != this.increments.length - 1) {
                    s = String.valueOf(s) + " , ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + ") ";
        s = this.action == null ? String.valueOf(s) + "{}" : String.valueOf(s) + "\n" + this.action.toString(tab + 1);
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            int i;
            if (this.initializations != null) {
                int initializationsLength = this.initializations.length;
                i = 0;
                while (i < initializationsLength) {
                    this.initializations[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, this.scope);
            }
            if (this.increments != null) {
                int incrementsLength = this.increments.length;
                i = 0;
                while (i < incrementsLength) {
                    this.increments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

