/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggerRepository;

public class Log4JLoggerManager
implements LoggerManager,
LogEnabled {
    private final Map m_loggers = new HashMap();
    private LoggerRepository m_hierarchy;
    private final Logger m_defaultLogger;
    private Logger m_logger;

    public Log4JLoggerManager() {
        this(LogManager.getLoggerRepository());
    }

    public Log4JLoggerManager(LoggerRepository hierarchy) {
        this(null, hierarchy);
    }

    public Log4JLoggerManager(String prefix) {
        this(prefix, LogManager.getLoggerRepository());
    }

    public Log4JLoggerManager(String prefix, LoggerRepository hierarchy) {
        this(prefix, hierarchy, (Logger)new Log4JLogger(hierarchy.getLogger("")));
    }

    public Log4JLoggerManager(String prefix, LoggerRepository hierarchy, Logger defaultLogger) {
        this(prefix, hierarchy, defaultLogger, defaultLogger);
    }

    public Log4JLoggerManager(String prefix, LoggerRepository hierarchy, Logger defaultLogger, Logger logger) {
        this.m_hierarchy = hierarchy;
        this.m_defaultLogger = defaultLogger;
        this.m_logger = logger;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public final Logger getLoggerForCategory(String categoryName) {
        Logger logger = (Logger)this.m_loggers.get(categoryName);
        if (null != logger) {
            if (this.m_logger.isDebugEnabled()) {
                String message = "Logger for category " + categoryName + " returned";
                this.m_logger.debug(message);
            }
            return logger;
        }
        if (this.m_logger.isDebugEnabled()) {
            String message = "Logger for category " + categoryName + " not defined in configuration. New Logger created and returned";
            this.m_logger.debug(message);
        }
        logger = new Log4JLogger(this.m_hierarchy.getLogger(categoryName));
        this.m_loggers.put(categoryName, logger);
        return logger;
    }

    public final Logger getDefaultLogger() {
        return this.m_defaultLogger;
    }
}

