/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.i18n.Bundle;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLResourceBundle
extends ResourceBundle
implements Bundle {
    protected static DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
    private Hashtable cache = new Hashtable();
    private Map cacheNotFound = new HashMap();
    private String name = "";
    private Document doc;
    private Locale locale;
    protected XMLResourceBundle parent = null;
    protected Logger logger;
    protected ComponentManager manager = null;
    private XPathProcessor processor = null;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.processor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void dispose() {
        this.manager.release((Component)this.processor);
        this.processor = null;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void init(String name, String fileName, Locale locale, XMLResourceBundle parent, boolean cacheAtStartup) throws IOException, ParserConfigurationException, SAXException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Constructing XMLResourceBundle: " + name + ", locale: " + locale);
        }
        this.name = name;
        this.doc = this.loadResourceBundle(fileName);
        this.locale = locale;
        this.parent = parent;
        if (cacheAtStartup) {
            Element root = this.doc.getDocumentElement();
            this.cacheAll(root, "/" + root.getNodeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized Document loadResourceBundle(String fileName) throws IOException, ParserConfigurationException, SAXException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Source source = null;
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            source = resolver.resolveURI(fileName);
            document = builder.parse(new InputSource(source.getInputStream()));
        }
        catch (Exception e) {
            try {
                this.logger.warn("XMLResourceBundle: Non excalibur-source " + fileName, (Throwable)e);
            }
            catch (Throwable throwable) {
                resolver.release(source);
                this.manager.release((Component)resolver);
                throw throwable;
            }
            resolver.release(source);
            this.manager.release((Component)resolver);
            return builder.parse(fileName);
        }
        resolver.release(source);
        this.manager.release((Component)resolver);
        return document;
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private boolean cacheNotFoundContains(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": cache_not_found contains: " + key);
        }
        return this.cacheNotFound.containsKey(key);
    }

    private void cacheKey(String key, Node value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": caching: " + key + " = " + value.toString());
        }
        this.cache.put(key, value);
    }

    private void cacheNotFoundKey(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": caching not_found: " + key);
        }
        this.cacheNotFound.put(key, "");
    }

    private Node getFromCache(String key) {
        Object value;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.name + ": returning from cache: " + key);
        }
        if ((value = this.cache.get(key)) == null) {
            this.logger.debug("Could not find!");
        }
        return (Node)value;
    }

    private void cacheAll(Node parent, String pathToParent) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caching all messages");
        }
        NodeList children = parent.getChildNodes();
        int childnum = children.getLength();
        for (int i = 0; i < childnum; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                StringBuffer pathToChild = new StringBuffer(pathToParent).append('/').append(child.getNodeName());
                NamedNodeMap attrs = child.getAttributes();
                if (attrs != null) {
                    Node temp = null;
                    int attrnum = attrs.getLength();
                    for (int j = 0; j < attrnum; ++j) {
                        temp = attrs.item(j);
                        if (temp.getNodeName().equalsIgnoreCase("xml:lang")) continue;
                        pathToChild.append("[@").append(temp.getNodeName()).append("='").append(temp.getNodeValue()).append("']");
                    }
                }
                this.cacheKey(pathToChild.toString(), child);
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("What we've cached: " + child.toString());
        }
    }

    private Object _getObject(String key) {
        if (key == null) {
            return null;
        }
        Node value = this.getFromCache(key);
        if (value == null && !this.cacheNotFoundContains(key)) {
            if (this.doc != null) {
                value = (Node)this._getObject(this.doc.getDocumentElement(), key);
            }
            if (value == null && this.parent != null) {
                value = (Node)this.parent._getObject(key);
            }
            if (value != null) {
                this.cacheKey(key, value);
            } else {
                this.cacheNotFoundKey(key);
            }
        }
        return value;
    }

    private Object _getObject(Node node, String key) {
        return this._getNode(node, key);
    }

    private Node _getNode(Node rootNode, String key) {
        try {
            return this.processor.selectSingleNode(rootNode, key);
        }
        catch (Exception e) {
            this.logger.error("Error while locating resource with key: " + key, (Throwable)e);
            return null;
        }
    }

    protected Object handleGetObject(String key) throws MissingResourceException {
        return this._getObject(key);
    }

    public Enumeration getKeys() {
        return this.cache.keys();
    }
}

