/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.PipelineEventComponentProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.PatternException;

public class SerializeNode
extends PipelineEventComponentProcessingNode {
    private String serializerName;
    private VariableResolver mimeType;
    private int statusCode;

    public SerializeNode(String name, VariableResolver mimeType, int statusCode) throws PatternException {
        this.serializerName = name;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        if (this.views != null) {
            ProcessingNode viewNode;
            context.getProcessingPipeline().informBranchPoint();
            String cocoonView = env.getView();
            if (cocoonView != null && (viewNode = (ProcessingNode)this.views.get(cocoonView)) != null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Jumping to view " + cocoonView + " from serializer at " + this.getLocation());
                }
                return viewNode.invoke(env, context);
            }
        }
        Map objectModel = env.getObjectModel();
        ProcessingPipeline pipeline = context.getProcessingPipeline();
        if (objectModel.containsKey("link")) {
            pipeline.addTransformer("<translator>", null, Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        }
        if (objectModel.containsKey("link-collection") && env.isExternal()) {
            pipeline.addTransformer("<gatherer>", null, Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        }
        pipeline.setSerializer(this.serializerName, null, Parameters.EMPTY_PARAMETERS, this.pipelineHints == null ? Parameters.EMPTY_PARAMETERS : VariableResolver.buildParameters(this.pipelineHints, context, objectModel), this.mimeType.resolve(context, env.getObjectModel()));
        if (this.statusCode >= 0) {
            env.setStatus(this.statusCode);
        }
        if (!context.isBuildingPipelineOnly()) {
            return pipeline.process(env);
        }
        return true;
    }
}

