/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGAltGlyphHandler;
import org.apache.batik.bridge.SVGFontUtilities;
import org.apache.batik.bridge.SVGTextPathElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGTextContent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class SVGTextElementBridge
extends AbstractGraphicsNodeBridge
implements SVGTextContent {
    protected static final Integer ZERO = new Integer(0);
    protected AttributedString layoutedText;
    protected DOMChildNodeRemovedEventListener childNodeRemovedEventListener = new DOMChildNodeRemovedEventListener();
    protected DOMSubtreeModifiedEventListener subtreeModifiedEventListener = new DOMSubtreeModifiedEventListener();
    private boolean hasNewACI;
    private Element cssProceedElement;

    public String getLocalName() {
        return "text";
    }

    public Bridge getInstance() {
        return new SVGTextElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        TextNode textNode = (TextNode)super.createGraphicsNode(bridgeContext, element);
        if (textNode == null) {
            return null;
        }
        if (bridgeContext.getTextPainter() != null) {
            textNode.setTextPainter(bridgeContext.getTextPainter());
        }
        RenderingHints renderingHints = CSSUtilities.convertTextRendering(element, null);
        if ((renderingHints = CSSUtilities.convertColorRendering(element, renderingHints)) != null) {
            textNode.setRenderingHints(renderingHints);
        }
        textNode.setLocation(this.getLocation(bridgeContext, element));
        return textNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new TextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "x");
        float f = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f = UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), "x", context);
        }
        string = element.getAttributeNS(null, "y");
        float f2 = 0.0f;
        if (string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
            f2 = UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), "y", context);
        }
        return new Point2D.Float(f, f2);
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        element.normalize();
        this.computeLayoutedText(bridgeContext, element, graphicsNode);
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        graphicsNode.setPointerEventType(CSSUtilities.convertPointerEvents(element));
        this.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public boolean isComposite() {
        return false;
    }

    protected void initializeDynamicSupport(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.initializeDynamicSupport(bridgeContext, element, graphicsNode);
        if (!bridgeContext.isDynamic()) {
            return;
        }
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        bridgeContext.storeEventListener(eventTarget, "DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.addEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        bridgeContext.storeEventListener(eventTarget, "DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.addContextToChild(bridgeContext, (Element)node);
        }
    }

    protected void addContextToChild(BridgeContext bridgeContext, Element element) {
        if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
            if (element.getLocalName().equals("tspan")) {
                ((SVGOMElement)element).setSVGContext(new TspanBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("textPath")) {
                ((SVGOMElement)element).setSVGContext(new TextPathBridge(bridgeContext, this, element));
            } else if (element.getLocalName().equals("tref")) {
                ((SVGOMElement)element).setSVGContext(new TRefBridge(bridgeContext, this, element));
            }
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.addContextToChild(bridgeContext, (Element)node);
        }
    }

    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.addContextToChild(this.ctx, (Element)node);
                this.layoutedText = null;
                break;
            }
        }
        if (this.layoutedText == null) {
            this.computeLayoutedText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        EventTarget eventTarget = mutationEvent.getTarget();
        eventTarget.removeEventListener("DOMNodeRemoved", this.childNodeRemovedEventListener, true);
        eventTarget.removeEventListener("DOMSubtreeModified", this.subtreeModifiedEventListener, false);
        super.handleDOMNodeRemovedEvent(mutationEvent);
    }

    public void handleDOMChildNodeRemovedEvent(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                if (!this.isParentDisplayed(node)) break;
                this.layoutedText = null;
                break;
            }
            case 1: {
                String string;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) break;
                this.layoutedText = null;
                break;
            }
        }
    }

    public void handleDOMSubtreeModifiedEvent(MutationEvent mutationEvent) {
        if (this.layoutedText == null) {
            this.computeLayoutedText(this.ctx, this.e, this.node);
        }
    }

    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        Node node = (Node)((Object)mutationEvent.getTarget());
        if (this.isParentDisplayed(node)) {
            this.layoutedText = null;
        }
    }

    protected boolean isParentDisplayed(Node node) {
        String string;
        Node node2 = node.getParentNode();
        return node2.getNodeType() == 1 && node2.getNamespaceURI().equals("http://www.w3.org/2000/svg") && ((string = node2.getLocalName()).equals("text") || string.equals("tspan") || string.equals("altGlyph") || string.equals("a") || string.equals("textPath") || string.equals("tref"));
    }

    protected void computeLayoutedText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        AttributedString attributedString = this.buildAttributedString(bridgeContext, element);
        this.addGlyphPositionAttributes(attributedString, element, bridgeContext);
        if (bridgeContext.isDynamic()) {
            this.layoutedText = new AttributedString(attributedString.getIterator());
        }
        TextNode textNode = (TextNode)graphicsNode;
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
        TextDecoration textDecoration = this.getTextDecoration(element, textNode, new TextDecoration(), bridgeContext);
        this.addPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
        textNode.setAttributedCharacterIterator(attributedString.getIterator());
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
            if (string.equals("x") || string.equals("y")) {
                ((TextNode)this.node).setLocation(this.getLocation(this.ctx, this.e));
            }
            this.computeLayoutedText(this.ctx, this.e, this.node);
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
        this.hasNewACI = false;
        int[] nArray = cSSEngineEvent.getProperties();
        block3: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 1: 
                case 11: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 32: 
                case 52: 
                case 55: 
                case 57: 
                case 58: {
                    if (this.hasNewACI) continue block3;
                    this.hasNewACI = true;
                    this.computeLayoutedText(this.ctx, this.e, this.node);
                }
            }
        }
        this.cssProceedElement = cSSEngineEvent.getElement();
        super.handleCSSEngineEvent(cSSEngineEvent);
        this.cssProceedElement = null;
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 15: 
            case 16: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                AttributedString attributedString;
                TextDecoration textDecoration;
                if (this.hasNewACI) break;
                this.hasNewACI = true;
                TextNode textNode = (TextNode)this.node;
                if (this.cssProceedElement == this.e) {
                    textDecoration = new TextDecoration();
                    attributedString = new AttributedString(this.layoutedText.getIterator());
                } else {
                    textDecoration = this.getParentTextDecoration(textNode.getAttributedCharacterIterator(), this.cssProceedElement);
                    attributedString = new AttributedString(textNode.getAttributedCharacterIterator());
                }
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                TextDecoration textDecoration2 = this.getTextDecoration(this.cssProceedElement, textNode, textDecoration, this.ctx);
                this.addPaintAttributes(attributedString, this.cssProceedElement, textNode, textDecoration2, this.ctx);
                textNode.setAttributedCharacterIterator(attributedString.getIterator());
                break;
            }
            case 54: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertTextRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            case 9: {
                RenderingHints renderingHints = this.node.getRenderingHints();
                renderingHints = CSSUtilities.convertColorRendering(this.e, renderingHints);
                if (renderingHints == null) break;
                this.node.setRenderingHints(renderingHints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        AttributedStringBuffer attributedStringBuffer = new AttributedStringBuffer();
        this.fillAttributedStringBuffer(bridgeContext, element, true, null, null, attributedStringBuffer);
        return attributedStringBuffer.toAttributedString();
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, TextPath textPath, Integer n, AttributedStringBuffer attributedStringBuffer) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        boolean bl3 = true;
        boolean bl4 = !bl2;
        boolean bl5 = !bl2;
        Element element2 = element;
        Map map = this.getAttributeMap(bridgeContext, element, textPath, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n2 = n;
        if (v != null) {
            n2 = (Integer)v;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl6 = node.getNextSibling() == null;
            int n3 = attributedStringBuffer.getLastChar();
            bl4 = !bl2 && bl3 && (bl || n3 == 32 || n3 == -1);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    Object object3;
                    if (node.getNamespaceURI() != "http://www.w3.org/2000/svg") break;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("tspan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n2, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("textPath")) {
                        object3 = (SVGTextPathElementBridge)bridgeContext.getBridge(element2);
                        object2 = ((SVGTextPathElementBridge)object3).createTextPath(bridgeContext, element2);
                        if (object2 == null) break;
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, (TextPath)object2, n2, attributedStringBuffer);
                        break;
                    }
                    if (string2.equals("tref")) {
                        object3 = XLinkSupport.getXLinkHref((Element)node);
                        object2 = bridgeContext.getReferencedElement((Element)node, (String)object3);
                        string = TextUtilities.getElementContent((Element)object2);
                        if ((string = this.normalizeString(string, bl2, bl4, bl6 && bl)) == null) break;
                        boolean bl7 = bl5 = !bl2 && string.charAt(0) == ' ';
                        if (bl5 && !attributedStringBuffer.isEmpty()) {
                            attributedStringBuffer.stripLast();
                        }
                        object = this.getAttributeMap(bridgeContext, element2, textPath, n);
                        attributedStringBuffer.append(string, (Map)object);
                        break;
                    }
                    if (!string2.equals("a")) break;
                    object3 = (EventTarget)((Object)element2);
                    object2 = bridgeContext.getUserAgent();
                    object = new SVGAElementBridge.AnchorListener((UserAgent)object2);
                    object3.addEventListener("click", (EventListener)object, false);
                    bridgeContext.storeEventListener((EventTarget)object3, "click", (EventListener)object, false);
                    this.fillAttributedStringBuffer(bridgeContext, element2, false, textPath, n2, attributedStringBuffer);
                    break;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl4, bl6 && bl);
                    if (string == null) break;
                    boolean bl8 = bl5 = !bl2 && string.charAt(0) == ' ';
                    if (bl5 && !attributedStringBuffer.isEmpty()) {
                        attributedStringBuffer.stripLast();
                    }
                    attributedStringBuffer.append(string, map);
                }
            }
            bl3 = false;
        }
    }

    protected String normalizeString(String string, boolean bl, boolean bl2, boolean bl3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            block10: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        stringBuffer.append(' ');
                        continue block10;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        } else {
            int n;
            boolean bl4 = false;
            if (bl2) {
                block11: for (int i = 0; i < string.length(); ++i) {
                    switch (string.charAt(i)) {
                        default: {
                            break block11;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block11;
                        }
                    }
                }
            }
            block12: for (n = i; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        continue block12;
                    }
                    case '\t': 
                    case ' ': {
                        if (bl4) continue block12;
                        stringBuffer.append(' ');
                        bl4 = true;
                        continue block12;
                    }
                    default: {
                        stringBuffer.append(c);
                        bl4 = false;
                    }
                }
            }
            if (bl3) {
                while ((n = stringBuffer.length()) > 0 && stringBuffer.charAt(n - 1) == ' ') {
                    stringBuffer.deleteCharAt(n - 1);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        if (bl2 && bl3) {
            return " ";
        }
        return null;
    }

    protected boolean nodeAncestorOf(Node node, Node node2) {
        Node node3;
        if (node2 == null || node == null) {
            return false;
        }
        for (node3 = node2.getParentNode(); node3 != null && node3 != node; node3 = node3.getParentNode()) {
        }
        return node3 == node;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        int n;
        int n2;
        ArrayList arrayList;
        Object object;
        int n3;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n4 = -1;
        for (n3 = 0; n3 < attributedCharacterIterator.getEndIndex(); ++n3) {
            attributedCharacterIterator.setIndex(n3);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 != element && !this.nodeAncestorOf(element, element2)) continue;
            n4 = n3;
            break;
        }
        if (n4 == -1) {
            return;
        }
        n3 = attributedCharacterIterator.getEndIndex() - 1;
        for (int i = attributedCharacterIterator.getEndIndex() - 1; i >= 0; --i) {
            attributedCharacterIterator.setIndex(i);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object != element && !this.nodeAncestorOf(element, (Node)object)) continue;
            n3 = i;
            break;
        }
        String string = element.getAttributeNS(null, "x");
        object = element.getAttributeNS(null, "y");
        String string2 = element.getAttributeNS(null, "dx");
        String string3 = element.getAttributeNS(null, "dy");
        String string4 = element.getAttributeNS(null, "rotate");
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        if (string.length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "x", string, bridgeContext);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (n4 + n > n3) continue;
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.X, arrayList.get(n), n4 + n, n4 + n + 1);
            }
        }
        if (((String)object).length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "y", (String)object, bridgeContext);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (n4 + n > n3) continue;
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.Y, arrayList.get(n), n4 + n, n4 + n + 1);
            }
        }
        if (string2.length() != 0) {
            arrayList = TextUtilities.svgHorizontalCoordinateArrayToUserSpace(element, "dx", string2, bridgeContext);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (n4 + n > n3) continue;
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DX, arrayList.get(n), n4 + n, n4 + n + 1);
            }
        }
        if (string3.length() != 0) {
            arrayList = TextUtilities.svgVerticalCoordinateArrayToUserSpace(element, "dy", string3, bridgeContext);
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                if (n4 + n > n3) continue;
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.DY, arrayList.get(n), n4 + n, n4 + n + 1);
            }
        }
        if (string4.length() != 0) {
            arrayList = TextUtilities.svgRotateArrayToFloats(element, "rotate", string4, bridgeContext);
            n2 = arrayList.size();
            if (n2 == 1) {
                attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(0), n4, n3 + 1);
            } else {
                for (n = 0; n < n2; ++n) {
                    if (n4 + n > n3) continue;
                    attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.ROTATION, arrayList.get(n), n4 + n, n4 + n + 1);
                }
            }
        }
        this.addChildGlyphPositionAttributes(attributedString, element, bridgeContext);
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) continue;
            this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        Object object;
        int n;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return;
        }
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        int n2 = -1;
        for (n = 0; n < attributedCharacterIterator.getEndIndex(); ++n) {
            attributedCharacterIterator.setIndex(n);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 != element && !this.nodeAncestorOf(element, element2)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        n = attributedCharacterIterator.getEndIndex() - 1;
        for (int i = attributedCharacterIterator.getEndIndex() - 1; i >= 0; --i) {
            attributedCharacterIterator.setIndex(i);
            object = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (object != element && !this.nodeAncestorOf(element, (Node)object)) continue;
            n = i;
            break;
        }
        Composite composite = CSSUtilities.convertOpacity(element);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OPACITY, composite, n2, n + 1);
        object = PaintServer.convertFillPaint(element, textNode, bridgeContext);
        attributedString.addAttribute(TextAttribute.FOREGROUND, object, n2, n + 1);
        Paint paint = PaintServer.convertStrokePaint(element, textNode, bridgeContext);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT, paint, n2, n + 1);
        Stroke stroke = PaintServer.convertStroke(element);
        attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE, stroke, n2, n + 1);
        if (textDecoration != null) {
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT, textDecoration.underlinePaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT, textDecoration.underlineStrokePaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE, textDecoration.underlineStroke, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT, textDecoration.overlinePaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT, textDecoration.overlineStrokePaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE, textDecoration.overlineStroke, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT, textDecoration.strikethroughPaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT, textDecoration.strikethroughStrokePaint, n2, n + 1);
            attributedString.addAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE, textDecoration.strikethroughStroke, n2, n + 1);
        }
        this.addChildPaintAttributes(attributedString, element, textNode, textDecoration, bridgeContext);
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) || !(string = node.getLocalName()).equals("tspan") && !string.equals("altGlyph") && !string.equals("a") && !string.equals("textPath") && !string.equals("tref")) continue;
            Element element2 = (Element)node;
            TextDecoration textDecoration2 = this.getTextDecoration(element2, textNode, textDecoration, bridgeContext);
            this.addPaintAttributes(attributedString, element2, textNode, textDecoration2, bridgeContext);
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        String string;
        Object object;
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        boolean bl = false;
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER, element);
        if (element.getTagName().equals("altGlyph")) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER, new SVGAltGlyphHandler(bridgeContext, element));
        }
        if (textPath != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH, textPath);
        }
        TextNode.Anchor anchor = TextUtilities.convertTextAnchor(element);
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE, anchor);
        Float f = TextUtilities.convertFontSize(element);
        hashMap.put(TextAttribute.SIZE, f);
        Float f2 = TextUtilities.convertFontWeight(element);
        Value value = CSSUtilities.getComputedStyle(element, 27);
        String string2 = value.getCssText();
        hashMap.put(TextAttribute.WEIGHT, f2);
        String string3 = CSSUtilities.getComputedStyle(element, 25).getStringValue();
        hashMap.put(TextAttribute.POSTURE, TextUtilities.convertFontStyle(element));
        String string4 = CSSUtilities.getComputedStyle(element, 24).getStringValue();
        hashMap.put(TextAttribute.WIDTH, TextUtilities.convertFontStretch(element));
        Value value2 = CSSUtilities.getComputedStyle(element, 21);
        Vector<GVTFontFamily> vector = new Vector<GVTFontFamily>();
        int n2 = value2.getLength();
        for (int i = 0; i < n2; ++i) {
            object = value2.item(i);
            String string5 = object.getStringValue();
            GVTFontFamily gVTFontFamily = SVGFontUtilities.getFontFamily(element, bridgeContext, string5, string2, string3);
            vector.add(gVTFontFamily);
        }
        hashMap.put(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES, vector);
        Object object2 = TextUtilities.convertBaselineShift(element);
        if (object2 != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT, object2);
        }
        if ((string = (value2 = CSSUtilities.getComputedStyle(element, 55)).getStringValue()).charAt(0) == 'n') {
            if (n != null) {
                hashMap.put(TextAttribute.BIDI_EMBEDDING, n);
            }
        } else {
            value2 = CSSUtilities.getComputedStyle(element, 11);
            object = value2.getStringValue();
            int n3 = 0;
            if (n != null) {
                n3 = n;
            }
            if (n3 < 0) {
                n3 = -n3;
            }
            switch (((String)object).charAt(0)) {
                case 'l': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    if ((n3 & 1) == 1) {
                        ++n3;
                        break;
                    }
                    n3 += 2;
                    break;
                }
                case 'r': {
                    hashMap.put(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    if ((n3 & 1) == 1) {
                        n3 += 2;
                        break;
                    }
                    ++n3;
                }
            }
            switch (string.charAt(0)) {
                case 'b': {
                    n3 = -n3;
                }
            }
            hashMap.put(TextAttribute.BIDI_EMBEDDING, new Integer(n3));
        }
        value2 = CSSUtilities.getComputedStyle(element, 58);
        string = value2.getStringValue();
        switch (string.charAt(0)) {
            case 'l': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR);
                break;
            }
            case 'r': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_RTL);
                break;
            }
            case 't': {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE, GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB);
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 29);
        switch (value2.getPrimitiveType()) {
            case 21: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO);
                break;
            }
            case 11: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float((double)(value2.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION, GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        value2 = CSSUtilities.getComputedStyle(element, 28);
        switch (value2.getPrimitiveType()) {
            case 11: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue()));
                break;
            }
            case 12: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float((double)(value2.getFloatValue() * 180.0f) / Math.PI));
                break;
            }
            case 13: {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE, new Float(value2.getFloatValue() * 9.0f / 5.0f));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        object = TextUtilities.convertLetterSpacing(element);
        if (object != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertWordSpacing(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((object = TextUtilities.convertKerning(element)) != null) {
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.KERNING, object);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
        }
        if ((string = element.getAttributeNS(null, "textLength")).length() != 0) {
            float f3 = UnitProcessor.svgOtherLengthToUserSpace(string, "textLength", context);
            hashMap.put(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH, new Float(f3));
            string = element.getAttributeNS(null, "lengthAdjust");
            if (string.length() < 10) {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING);
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING, Boolean.TRUE);
            } else {
                hashMap.put(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST, GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL);
            }
        }
        return hashMap;
    }

    protected TextDecoration getParentTextDecoration(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        Element element2 = null;
        int n = -1;
        for (int i = 0; i < attributedCharacterIterator.getEndIndex(); ++i) {
            attributedCharacterIterator.setIndex(i);
            Element element3 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (this.nodeAncestorOf(element3, element)) {
                element2 = element3;
                n = i;
            }
            if (element3 == element || this.nodeAncestorOf(element, element3)) break;
        }
        TextDecoration textDecoration = new TextDecoration();
        if (element2 == null) {
            return textDecoration;
        }
        attributedCharacterIterator.setIndex(n);
        textDecoration.underlinePaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_PAINT);
        textDecoration.underlineStrokePaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE_PAINT);
        textDecoration.underlineStroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.UNDERLINE_STROKE);
        textDecoration.overlinePaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_PAINT);
        textDecoration.overlineStrokePaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE_PAINT);
        textDecoration.overlineStroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.OVERLINE_STROKE);
        textDecoration.strikethroughPaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_PAINT);
        textDecoration.strikethroughStrokePaint = (Paint)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE_PAINT);
        textDecoration.strikethroughStroke = (Stroke)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STRIKETHROUGH_STROKE);
        return textDecoration;
    }

    protected TextDecoration getTextDecoration(Element element, GraphicsNode graphicsNode, TextDecoration textDecoration, BridgeContext bridgeContext) {
        int n = 53;
        Value value = CSSUtilities.getComputedStyle(element, n);
        StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
        if (styleMap.isNullCascaded(n)) {
            return textDecoration;
        }
        TextDecoration textDecoration2 = new TextDecoration(textDecoration);
        short s = value.getCssValueType();
        switch (value.getCssValueType()) {
            case 2: {
                ListValue listValue = (ListValue)value;
                Paint paint = PaintServer.convertFillPaint(element, graphicsNode, bridgeContext);
                Paint paint2 = PaintServer.convertStrokePaint(element, graphicsNode, bridgeContext);
                Stroke stroke = PaintServer.convertStroke(element);
                int n2 = listValue.getLength();
                block8: for (int i = 0; i < n2; ++i) {
                    Value value2 = listValue.item(i);
                    String string = value2.getStringValue();
                    switch (string.charAt(0)) {
                        case 'u': {
                            if (paint != null) {
                                textDecoration2.underlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.underlineStrokePaint = paint2;
                            }
                            if (stroke == null) continue block8;
                            textDecoration2.underlineStroke = stroke;
                            continue block8;
                        }
                        case 'o': {
                            if (paint != null) {
                                textDecoration2.overlinePaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.overlineStrokePaint = paint2;
                            }
                            if (stroke == null) continue block8;
                            textDecoration2.overlineStroke = stroke;
                            continue block8;
                        }
                        case 'l': {
                            if (paint != null) {
                                textDecoration2.strikethroughPaint = paint;
                            }
                            if (paint2 != null) {
                                textDecoration2.strikethroughStrokePaint = paint2;
                            }
                            if (stroke == null) continue block8;
                            textDecoration2.strikethroughStroke = stroke;
                        }
                    }
                }
                return textDecoration2;
            }
        }
        return TextDecoration.EMPTY_TEXT_DECORATION;
    }

    public int getNumberOfChars() {
        return this.getNumberOfChars(this.e);
    }

    public Rectangle2D getExtentOfChar(int n) {
        return this.getExtentOfChar(this.e, n);
    }

    public Point2D getStartPositionOfChar(int n) {
        return this.getStartPositionOfChar(this.e, n);
    }

    public Point2D getEndPositionOfChar(int n) {
        return this.getEndPositionOfChar(this.e, n);
    }

    public void selectSubString(int n, int n2) {
        this.selectSubString(this.e, n, n2);
    }

    public float getRotationOfChar(int n) {
        return this.getRotationOfChar(this.e, n);
    }

    public float getComputedTextLength() {
        return this.getComputedTextLength(this.e);
    }

    public float getSubStringLength(int n, int n2) {
        return this.getSubStringLength(this.e, n, n2);
    }

    public int getCharNumAtPosition(float f, float f2) {
        return this.getCharNumAtPosition(this.e, f, f2);
    }

    protected int getNumberOfChars(Element element) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n == -1) {
            return 0;
        }
        int n2 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        Object var5_5 = null;
        List list = this.getTextRuns((TextNode)this.node);
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)list.get(j);
                TextSpanLayout textSpanLayout = textRun.getLayout();
                if (!textSpanLayout.hasCharacterIndex(i)) continue;
                if (textSpanLayout.isOnATextPath()) {
                    int n4;
                    int n5;
                    GVTGlyphVector gVTGlyphVector = textSpanLayout.getGlyphVector();
                    if (textSpanLayout.isAltGlyph()) {
                        int n6;
                        n5 = gVTGlyphVector.getNumGlyphs();
                        n4 = 0;
                        for (n6 = 0; n6 < n5; ++n6) {
                            if (!gVTGlyphVector.isGlyphVisible(n6)) continue;
                            ++n4;
                        }
                        n6 = 1;
                        while (textSpanLayout.hasCharacterIndex(i + 1)) {
                            ++n6;
                            ++i;
                        }
                        n3 += n6 * n4 / n5;
                        continue;
                    }
                    n5 = -1;
                    do {
                        if ((n4 = textSpanLayout.getGlyphIndex(i)) == -1) {
                            n4 = textSpanLayout.isLeftToRight() ? 1 + n5 : (n5 == -1 ? gVTGlyphVector.getNumGlyphs() - 1 : n5 - 1);
                        }
                        n5 = n4;
                        if (!gVTGlyphVector.isGlyphVisible(n4)) continue;
                        ++n3;
                    } while (++i <= n2 && textSpanLayout.hasCharacterIndex(i));
                    --i;
                    continue;
                }
                ++n3;
                while (i < n2 && textSpanLayout.hasCharacterIndex(i + 1)) {
                    ++i;
                    ++n3;
                }
            }
        }
        return n3;
    }

    protected Rectangle2D getExtentOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            Cloneable cloneable;
            Object object;
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            if (characterInformation.glyphIndexStart == characterInformation.glyphIndexEnd) {
                object = gVTGlyphVector.getGlyphOutline(characterInformation.glyphIndexStart);
            } else {
                cloneable = new GeneralPath();
                for (int i = characterInformation.glyphIndexStart; i <= characterInformation.glyphIndexEnd; ++i) {
                    ((Path2D)cloneable).append(gVTGlyphVector.getGlyphOutline(i), false);
                }
                object = cloneable;
            }
            cloneable = this.getCTM();
            object = ((AffineTransform)cloneable).createTransformedShape((Shape)object);
            return object.getBounds2D();
        }
        return null;
    }

    protected Point2D getStartPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            return this.getStartPoint(characterInformation);
        }
        return null;
    }

    protected Point2D getStartPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexStart);
        Point2D.Float float_ = new Point2D.Float();
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexStart);
        double d = 0.0;
        double d2 = 0.0;
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(d, d2), float_);
            d = ((Point2D)float_).getX();
            d2 = ((Point2D)float_).getY();
        }
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        affineTransform2.transform(new Point2D.Double(d, d2), float_);
        AffineTransform affineTransform3 = new AffineTransform(this.getCTM());
        Point2D.Float float_2 = new Point2D.Float();
        affineTransform3.transform(float_, float_2);
        return float_2;
    }

    protected Point2D getEndPositionOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return null;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        if (characterInformation != null) {
            return this.getEndPoint(characterInformation);
        }
        return null;
    }

    protected Point2D getEndPoint(CharacterInformation characterInformation) {
        GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
        Point2D point2D = gVTGlyphVector.getGlyphPosition(characterInformation.glyphIndexEnd);
        Point2D.Float float_ = new Point2D.Float();
        AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(characterInformation.glyphIndexEnd);
        GVTGlyphMetrics gVTGlyphMetrics = gVTGlyphVector.getGlyphMetrics(characterInformation.glyphIndexEnd);
        double d = 0.0;
        double d2 = 0.0;
        d = gVTGlyphMetrics.getHorizontalAdvance();
        if (affineTransform != null) {
            affineTransform.transform(new Point2D.Double(d, d2), float_);
            d = ((Point2D)float_).getX();
            d2 = ((Point2D)float_).getY();
        }
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
        affineTransform2.transform(new Point2D.Double(d, d2), float_);
        AffineTransform affineTransform3 = new AffineTransform(this.getCTM());
        Point2D.Float float_2 = new Point2D.Float();
        affineTransform3.transform(float_, float_2);
        return float_2;
    }

    protected float getRotationOfChar(Element element, int n) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n2 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n2 == -1) {
            return 0.0f;
        }
        List list = this.getTextRuns((TextNode)this.node);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n2, n, attributedCharacterIterator);
        double d = 0.0;
        int n3 = 0;
        if (characterInformation != null) {
            GVTGlyphVector gVTGlyphVector = characterInformation.layout.getGlyphVector();
            for (int i = characterInformation.glyphIndexStart; i <= characterInformation.glyphIndexEnd; ++i) {
                ++n3;
                double d2 = 0.0;
                AffineTransform affineTransform = gVTGlyphVector.getGlyphTransform(i);
                if (affineTransform == null) continue;
                double d3 = affineTransform.getScaleX();
                double d4 = affineTransform.getShearX();
                if (d3 == 0.0) {
                    d2 = d4 > 0.0 ? Math.PI : -Math.PI;
                } else {
                    d2 = Math.atan(d4 / d3);
                    if (d3 < 0.0) {
                        d2 += Math.PI;
                    }
                }
                d2 = Math.toDegrees(-d2) % 360.0;
                d += d2 - characterInformation.getComputedOrientationAngle();
            }
        }
        return (float)(d / (double)n3);
    }

    protected float getComputedTextLength(Element element) {
        return this.getSubStringLength(element, 0, this.getNumberOfChars(element));
    }

    protected float getSubStringLength(Element element, int n, int n2) {
        float f = 0.0f;
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n3 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n3 == -1) {
            return -1.0f;
        }
        List list = this.getTextRuns(textNode);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = null;
        int n4 = characterInformation.characterIndex + 1;
        for (int i = n + 1; i < n + n2; ++i) {
            if (characterInformation.layout.hasCharacterIndex(n4)) {
                ++n4;
                continue;
            }
            characterInformation2 = this.getCharacterInformation(list, n3, i - 1, attributedCharacterIterator);
            f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
            characterInformation = this.getCharacterInformation(list, n3, i, attributedCharacterIterator);
            n4 = characterInformation.characterIndex + 1;
            characterInformation2 = null;
        }
        if (characterInformation2 == null) {
            characterInformation2 = this.getCharacterInformation(list, n3, n + n2 - 1, attributedCharacterIterator);
        }
        return f += this.distanceFirstLastCharacterInRun(characterInformation, characterInformation2);
    }

    protected float distanceFirstLastCharacterInRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        float[] fArray = characterInformation.layout.getGlyphAdvances();
        int n = characterInformation.glyphIndexStart;
        int n2 = characterInformation.glyphIndexEnd;
        int n3 = characterInformation2.glyphIndexStart;
        int n4 = characterInformation2.glyphIndexEnd;
        int n5 = n < n3 ? n : n3;
        int n6 = n2 < n4 ? n4 : n2;
        return fArray[n6 + 1] - fArray[n5];
    }

    protected float distanceBetweenRun(CharacterInformation characterInformation, CharacterInformation characterInformation2) {
        CharacterInformation characterInformation3 = new CharacterInformation();
        characterInformation3.layout = characterInformation.layout;
        characterInformation3.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
        Point2D point2D = this.getEndPoint(characterInformation3);
        characterInformation3.layout = characterInformation2.layout;
        characterInformation3.glyphIndexStart = 0;
        Point2D point2D2 = this.getStartPoint(characterInformation3);
        float f = characterInformation2.isVertical() ? (float)(point2D2.getY() - point2D.getY()) : (float)(point2D2.getX() - point2D.getX());
        return f;
    }

    protected void selectSubString(Element element, int n, int n2) {
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        TextNode textNode = (TextNode)this.node;
        int n3 = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        if (n3 == -1) {
            return;
        }
        List list = this.getTextRuns(textNode);
        int n4 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        CharacterInformation characterInformation = this.getCharacterInformation(list, n3, n, attributedCharacterIterator);
        CharacterInformation characterInformation2 = this.getCharacterInformation(list, n3, n + n2 - 1, attributedCharacterIterator);
        Mark mark = textNode.getMarkerForChar(characterInformation.characterIndex, true);
        Mark mark2 = characterInformation2 != null && characterInformation2.characterIndex <= n4 ? textNode.getMarkerForChar(characterInformation2.characterIndex, false) : textNode.getMarkerForChar(n4, false);
        textNode.setSelection(mark, mark2);
    }

    protected int getCharNumAtPosition(Element element, float f, float f2) {
        TextNode textNode = (TextNode)this.node;
        List list = this.getTextRuns(textNode);
        TextHit textHit = null;
        for (int i = list.size() - 1; i >= 0 && textHit == null; --i) {
            textHit = ((StrokingTextPainter.TextRun)list.get(i)).getLayout().hitTestChar(f, f2);
        }
        if (textHit == null) {
            return -1;
        }
        AttributedCharacterIterator attributedCharacterIterator = ((TextNode)this.node).getAttributedCharacterIterator();
        int n = this.getFirstCharacterIndexForElement(attributedCharacterIterator, element);
        int n2 = this.getLastCharacterIndexForElement(attributedCharacterIterator, element);
        int n3 = textHit.getCharIndex();
        if (n3 >= n && n3 <= n2) {
            return n3 - n;
        }
        return -1;
    }

    protected int getFirstCharacterIndexForElement(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = -1;
        for (int i = 0; i < attributedCharacterIterator.getEndIndex(); ++i) {
            attributedCharacterIterator.setIndex(i);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 != element && !this.nodeAncestorOf(element, element2)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected int getLastCharacterIndexForElement(AttributedCharacterIterator attributedCharacterIterator, Element element) {
        int n = attributedCharacterIterator.getEndIndex() - 1;
        for (int i = attributedCharacterIterator.getEndIndex() - 1; i >= 0; --i) {
            attributedCharacterIterator.setIndex(i);
            Element element2 = (Element)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER);
            if (element2 != element && !this.nodeAncestorOf(element, element2)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected List getTextRuns(TextNode textNode) {
        if (textNode.getTextRuns() == null) {
            textNode.getPrimitiveBounds();
        }
        return textNode.getTextRuns();
    }

    protected CharacterInformation getCharacterInformation(List list, int n, int n2, AttributedCharacterIterator attributedCharacterIterator) {
        int n3;
        GVTGlyphVector gVTGlyphVector;
        int n4 = 0;
        int n5 = 0;
        StrokingTextPainter.TextRun textRun = null;
        n5 = n;
        while (n4 < n2 + 1) {
            for (int i = 0; i < list.size() && n4 < n2 + 1; ++i) {
                textRun = (StrokingTextPainter.TextRun)list.get(i);
                TextSpanLayout textSpanLayout = textRun.getLayout();
                if (!textSpanLayout.hasCharacterIndex(n5)) continue;
                if (textSpanLayout.isOnATextPath()) {
                    int n6;
                    gVTGlyphVector = textSpanLayout.getGlyphVector();
                    if (textSpanLayout.isAltGlyph()) {
                        int n7;
                        n3 = gVTGlyphVector.getNumGlyphs();
                        n6 = 0;
                        for (n7 = 0; n7 < n3; ++n7) {
                            if (!gVTGlyphVector.isGlyphVisible(n7)) continue;
                            ++n6;
                        }
                        n7 = 1;
                        while (textSpanLayout.hasCharacterIndex(n5 + 1)) {
                            ++n7;
                            ++n5;
                        }
                        if ((n4 += n7 * n6 / n3) <= n2 + 1) continue;
                        n4 = n2 + 1;
                        continue;
                    }
                    n3 = -1;
                    do {
                        if ((n6 = textSpanLayout.getGlyphIndex(n5)) == -1) {
                            n6 = textSpanLayout.isLeftToRight() ? 1 + n3 : (n3 == -1 ? gVTGlyphVector.getNumGlyphs() - 1 : n3 - 1);
                        }
                        n3 = n6;
                        if (!gVTGlyphVector.isGlyphVisible(n6)) continue;
                        ++n4;
                    } while (n4 < n2 + 1 && textSpanLayout.hasCharacterIndex(++n5));
                    --n5;
                    continue;
                }
                ++n4;
                while (n4 < n2 + 1 && textSpanLayout.hasCharacterIndex(n5 + 1)) {
                    ++n5;
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 != n2 + 1) {
            return null;
        }
        CharacterInformation characterInformation = new CharacterInformation();
        characterInformation.characterIndex = n5 - 1;
        characterInformation.layout = textRun.getLayout();
        if (characterInformation.layout.isAltGlyph()) {
            characterInformation.glyphIndexStart = 0;
            characterInformation.glyphIndexEnd = characterInformation.layout.getGlyphCount() - 1;
            boolean bl = false;
            gVTGlyphVector = characterInformation.layout.getGlyphVector();
            for (n3 = 0; n3 < gVTGlyphVector.getNumGlyphs(); ++n3) {
                if (!bl && gVTGlyphVector.isGlyphVisible(n3)) {
                    characterInformation.glyphIndexStart = n3;
                    bl = true;
                }
                if (!bl || gVTGlyphVector.isGlyphVisible(n3)) continue;
                characterInformation.glyphIndexEnd = n3 - 1;
                break;
            }
        } else {
            characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex);
            if (characterInformation.glyphIndexStart == -1) {
                if (characterInformation.layout.isLeftToRight()) {
                    characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex - 1) + 1;
                } else {
                    characterInformation.glyphIndexStart = characterInformation.layout.getGlyphIndex(characterInformation.characterIndex + 1) - 1;
                    if (characterInformation.glyphIndexStart == -2) {
                        characterInformation.glyphIndexStart = characterInformation.layout.getGlyphCount() - 1;
                    }
                }
            }
            characterInformation.glyphIndexEnd = characterInformation.glyphIndexStart;
        }
        return characterInformation;
    }

    protected class CharacterInformation {
        TextSpanLayout layout;
        int glyphIndexStart;
        int glyphIndexEnd;
        int characterIndex;

        protected CharacterInformation() {
        }

        public boolean isVertical() {
            return this.layout.isVertical();
        }

        public double getComputedOrientationAngle() {
            return this.layout.getComputedOrientationAngle(this.characterIndex);
        }
    }

    protected class TspanBridge
    extends AbstractTextChildTextContent {
        public TspanBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLayoutedText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class TextPathBridge
    extends AbstractTextChildTextContent {
        public TextPathBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }
    }

    protected class TRefBridge
    extends AbstractTextChildTextContent {
        public TRefBridge(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
            String string = mutationEvent.getAttrName();
            if (string.equals("x") || string.equals("y") || string.equals("dx") || string.equals("dy") || string.equals("rotate")) {
                this.textBridge.computeLayoutedText(this.ctx, this.textBridge.e, this.textBridge.node);
            }
        }
    }

    protected class AbstractTextChildTextContent
    extends AbstractTextChildBridgeUpdateHandler
    implements SVGTextContent {
        public AbstractTextChildTextContent(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public int getNumberOfChars() {
            return this.textBridge.getNumberOfChars(this.e);
        }

        public Rectangle2D getExtentOfChar(int n) {
            return this.textBridge.getExtentOfChar(this.e, n);
        }

        public Point2D getStartPositionOfChar(int n) {
            return this.textBridge.getStartPositionOfChar(this.e, n);
        }

        public Point2D getEndPositionOfChar(int n) {
            return this.textBridge.getEndPositionOfChar(this.e, n);
        }

        public void selectSubString(int n, int n2) {
            this.textBridge.selectSubString(this.e, n, n2);
        }

        public float getRotationOfChar(int n) {
            return this.textBridge.getRotationOfChar(this.e, n);
        }

        public float getComputedTextLength() {
            return this.textBridge.getComputedTextLength(this.e);
        }

        public float getSubStringLength(int n, int n2) {
            return this.textBridge.getSubStringLength(this.e, n, n2);
        }

        public int getCharNumAtPosition(float f, float f2) {
            return this.textBridge.getCharNumAtPosition(this.e, f, f2);
        }
    }

    protected abstract class AbstractTextChildBridgeUpdateHandler
    extends AbstractTextChildSVGContext
    implements BridgeUpdateHandler {
        public AbstractTextChildBridgeUpdateHandler(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            super(bridgeContext, sVGTextElementBridge2, element);
        }

        public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        }

        public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
            this.textBridge.handleDOMNodeInsertedEvent(mutationEvent);
        }

        public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
            this.dispose();
        }

        public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
            this.textBridge.handleDOMCharacterDataModified(mutationEvent);
        }

        public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
            this.textBridge.handleCSSEngineEvent(cSSEngineEvent);
        }

        public void dispose() {
            ((SVGOMElement)this.e).setSVGContext(null);
        }
    }

    protected abstract class AbstractTextChildSVGContext
    implements SVGContext {
        protected BridgeContext ctx;
        protected SVGTextElementBridge textBridge;
        protected Element e;

        public AbstractTextChildSVGContext(BridgeContext bridgeContext, SVGTextElementBridge sVGTextElementBridge2, Element element) {
            this.ctx = bridgeContext;
            this.textBridge = sVGTextElementBridge2;
            this.e = element;
        }

        public float getPixelUnitToMillimeter() {
            return this.ctx.getUserAgent().getPixelUnitToMillimeter();
        }

        public float getPixelToMM() {
            return this.getPixelUnitToMillimeter();
        }

        public Rectangle2D getBBox() {
            return null;
        }

        public AffineTransform getCTM() {
            return null;
        }

        public AffineTransform getGlobalTransform() {
            return null;
        }

        public AffineTransform getScreenTransform() {
            return null;
        }

        public void setScreenTransform(AffineTransform affineTransform) {
        }

        public float getViewportWidth() {
            return this.ctx.getBlockWidth(this.e);
        }

        public float getViewportHeight() {
            return this.ctx.getBlockHeight(this.e);
        }

        public float getFontSize() {
            return CSSUtilities.getComputedStyle(this.e, 22).getFloatValue();
        }
    }

    protected static class TextDecoration {
        static final TextDecoration EMPTY_TEXT_DECORATION = new TextDecoration();
        Paint underlinePaint;
        Paint underlineStrokePaint;
        Stroke underlineStroke;
        Paint overlinePaint;
        Paint overlineStrokePaint;
        Stroke overlineStroke;
        Paint strikethroughPaint;
        Paint strikethroughStrokePaint;
        Stroke strikethroughStroke;

        TextDecoration() {
            this.underlinePaint = null;
            this.underlineStrokePaint = null;
            this.underlineStroke = null;
            this.overlinePaint = null;
            this.overlineStrokePaint = null;
            this.overlineStroke = null;
            this.strikethroughPaint = null;
            this.strikethroughStrokePaint = null;
            this.strikethroughStroke = null;
        }

        TextDecoration(TextDecoration textDecoration) {
            this.underlinePaint = textDecoration.underlinePaint;
            this.underlineStrokePaint = textDecoration.underlineStrokePaint;
            this.underlineStroke = textDecoration.underlineStroke;
            this.overlinePaint = textDecoration.overlinePaint;
            this.overlineStrokePaint = textDecoration.overlineStrokePaint;
            this.overlineStroke = textDecoration.overlineStroke;
            this.strikethroughPaint = textDecoration.strikethroughPaint;
            this.strikethroughStrokePaint = textDecoration.strikethroughStrokePaint;
            this.strikethroughStroke = textDecoration.strikethroughStroke;
        }
    }

    protected static class AttributedStringBuffer {
        protected List strings = new ArrayList();
        protected List attributes = new ArrayList();
        protected int count = 0;
        protected int length = 0;

        public boolean isEmpty() {
            return this.count == 0;
        }

        public int length() {
            return this.length;
        }

        public void append(String string, Map map) {
            if (string.length() == 0) {
                return;
            }
            this.strings.add(string);
            this.attributes.add(map);
            ++this.count;
            this.length += string.length();
        }

        public int getLastChar() {
            if (this.count == 0) {
                return -1;
            }
            String string = (String)this.strings.get(this.count - 1);
            return string.charAt(string.length() - 1);
        }

        public void stripLast() {
            String string = (String)this.strings.remove(this.count - 1);
            if (string.charAt(string.length() - 1) == ' ') {
                if (string.length() == 1) {
                    this.attributes.remove(--this.count);
                    return;
                }
                this.strings.add(string.substring(0, string.length() - 1));
                --this.length;
            } else {
                this.strings.add(string);
            }
        }

        public AttributedString toAttributedString() {
            switch (this.count) {
                case 0: {
                    return new AttributedString(" ");
                }
                case 1: {
                    return new AttributedString((String)this.strings.get(0), (Map)this.attributes.get(0));
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            AttributedString attributedString = new AttributedString(stringBuffer.toString());
            Iterator iterator2 = this.strings.iterator();
            Iterator iterator3 = this.attributes.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                int n2 = n + string.length();
                Map map = (Map)iterator3.next();
                Iterator iterator4 = map.keySet().iterator();
                Iterator iterator5 = map.values().iterator();
                while (iterator4.hasNext()) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator4.next();
                    Object v = iterator5.next();
                    attributedString.addAttribute(attribute, v, n, n2);
                }
                n = n2;
            }
            return attributedString;
        }

        public String toString() {
            switch (this.count) {
                case 0: {
                    return "";
                }
                case 1: {
                    return (String)this.strings.get(0);
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.strings.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            return stringBuffer.toString();
        }
    }

    protected class DOMSubtreeModifiedEventListener
    implements EventListener {
        protected DOMSubtreeModifiedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMSubtreeModifiedEvent((MutationEvent)event);
        }
    }

    protected class DOMChildNodeRemovedEventListener
    implements EventListener {
        protected DOMChildNodeRemovedEventListener() {
        }

        public void handleEvent(Event event) {
            SVGTextElementBridge.this.handleDOMChildNodeRemovedEvent((MutationEvent)event);
        }
    }
}

